% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dday.R
\encoding{UTF-8}
\name{dday}
\alias{dday}
\title{Calcul de la valeur dday d'une serie.}
\usage{
dday(data, date, d = 0, x, unite = 1, decimal = 0)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date que l'on souhaite connaitre la valeur de la serie.}

\item{d}{Une valeur de type entier qui permet de décaler le jour par rapport à la date introduite. Sa valeur par defaut est \code{0}.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{unite}{Une valeur de type numeric, definissant l'ordre d'echelle d'affisage du resultat de la fonction. Sa valeur par defaut est \code{1}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{0}.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de trouver la valeur d'une série à une date voulue par l'utilisateur, le dday.
}
\examples{
x <- rnorm(222, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2023-01-01"), by = "day", len = 222)
df <- data.frame(date, x)
dday(df, date = "2023-07-06", x = "x")

}
