% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset_config.R
\name{last_insetcfg}
\alias{last_insetcfg}
\title{Get Last Inset Configuration}
\usage{
last_insetcfg()
}
\value{
An inset configuration object of class \code{insetcfg}, or NULL if no
configuration has been set.
}
\description{
Retrieves the most recently created inset configuration object.
This is used internally by \code{\link[=with_inset]{with_inset()}} when no configuration is explicitly provided.
}
\examples{
library(sf)

# Load some spatial data
nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

# Configure inset map
config_insetmap(
    data_list = list(nc),
    specs = list(
        inset_spec(main = TRUE),
        inset_spec(
            xmin = -84, xmax = -75, ymin = 33, ymax = 37,
            loc = "left bottom",
            width = 0.3
        )
    )
)

# Retrieve the configuration
cfg <- last_insetcfg()

}
