% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injprev.R
\name{injprev}
\alias{injprev}
\title{Calculate injury prevalence}
\usage{
injprev(injd, by = c("monthly", "season"), var_type_injury = NULL)
}
\arguments{
\item{injd}{Prepared data. An \code{injd} object.}

\item{by}{Character. One of "monthly" or "season", specifying the periodicity
according to which to calculate the proportions of available and injured
players/athletes.}

\item{var_type_injury}{Character specifying the name of the column on the
basis of which to classify the injuries and calculate proportions of the
injured players. Defaults to \code{NULL}.}
}
\value{
A data frame containing one row for each combination of season, month
(optionally) and injury type (if \code{var_type_injury} not specified, then this
variable has two categories: \emph{Available} and \emph{Injured}). Plus, three more
columns, specifying the proportion of players (\code{prop}) satisfying the
corresponding row's combination of values, i.e. prevalence, how many
players were injured at that moment with the type of injury of the
corresponding row (\code{n}), over how many players were at that time in the
cohort (\code{n_player}). See Note section.
}
\description{
Calculate the prevalence of injured players and the proportion of non-injured
(available) players in the cohort, on a monthly or season basis. Further
information on the type of injury may be specified so that the
injury-specific prevalences are reported according to this variable.
}
\note{
If \code{var_type_injury} is specified (and not \code{NULL}), it may happen that a
player in one month suffers two different types of injuries. For example, a
muscle and a ligament injury. In this case, this two injuries contribute to
the proportions of muscle and ligament injuries for that month, resulting in
an overall proportion that exceeds 100\%. Besides, the players in Available
category are those that did not suffer any injury in that moment
(season-month), that is, they were healthy all the time that the period
lasted
}
\examples{
\donttest{
df_exposures <- prepare_exp(raw_df_exposures, player = "player_name",
                            date = "year", time_expo = "minutes_played")
df_injuries  <- prepare_inj(raw_df_injuries, player = "player_name",
                            date_injured = "from", date_recovered = "until")
injd         <- prepare_all(data_exposures = df_exposures,
                            data_injuries  = df_injuries,
                            exp_unit = "matches_minutes")
}

injprev(injd, by = "monthly", var_type_injury = "injury_type")
injprev(injd, by = "monthly")
injprev(injd, by = "season", var_type_injury = "injury_type")
injprev(injd, by = "season")
}
\references{
Bahr R, Clarsen B, Derman W, et al. International Olympic Committee
consensus statement: methods for recording and reporting of epidemiological
data on injury and illness in sport 2020 (including STROBE Extension for
Sport Injury and Illness Surveillance (STROBE-SIIS)) \emph{British Journal of
Sports Medicine} 2020; 54:372-389.
}
