% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaimsByLinkRatio.R
\name{ClaimsByLinkRatio}
\alias{ClaimsByLinkRatio}
\title{Claims by link ratio}
\usage{
ClaimsByLinkRatio(dfClaims, Links, Lags)
}
\arguments{
\item{dfClaims}{A claims data frame}

\item{Links}{A list of functions which dictate how severities change from one evaluation date to the next}

\item{Lags}{A vector of lags}
}
\value{
A claims data frame
}
\description{
Given a data frame of claims, this will simulate claim development by applying a (possibly) random link ratio.
}
\details{
This function will apply the link ratio algorithm at an individual claim level.
}
\examples{

dfPolicy <- NewPolicyYear(10, 2001)
dfClaims <- ClaimsByFirstReport(
               dfPolicy
             , Frequency = FixedHelper(10)
             , PaymentSeverity = FixedHelper(100)
             , Lags = 1)
dfClaims <- ClaimsByLinkRatio(dfClaims
                              , Links = FixedHelper(c(1.25, 1.1, 1.05))
                              , Lags = 1:4)

}
