% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coredata}
\alias{coredata}
\alias{coredata.ichimoku}
\title{Extract the Core Data of Ichimoku Objects}
\usage{
\method{coredata}{ichimoku}(x, fmt, ...)
}
\arguments{
\item{x}{an object of class \sQuote{ichimoku}.}

\item{fmt}{(optional) set to TRUE to retain the index as row names of the
returned matrix, or a character string passed on to the \sQuote{format}
argument of \code{format.POSIXct()} to format these values in a specific
way.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A numeric matrix containing the ichimoku object data, stripped of the
    index unless \sQuote{fmt} is specified in which case the index will be
    retained as character values in the matrix row names.
}
\description{
Method for extracting the core data matrix of ichimoku objects.
}
\details{
This function is an S3 method for the generic function coredata()
    for class \sQuote{ichimoku}. It can be invoked by calling coredata(x) on
    an object \sQuote{x} of class \sQuote{ichimoku}.
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
coredata(cloud)[101:120, ]

}
