% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_create.R
\name{hs_create}
\alias{hs_create}
\title{Create annotations}
\source{
\url{https://h.readthedocs.io/en/latest/api/#create}
}
\usage{
hs_create(token, uri, user, permissions = list(read = "group:__world__",
  update = user, delete = user, admin = user), document = NULL,
  target = NULL, tags = NULL, text, custom = NULL)
}
\arguments{
\item{token}{Character. Your account token, which you can generate at \url{https://hypothes.is/register}}

\item{uri}{Character. The URI to be annotated.}

\item{user}{Character. Your user account, normally in the format \code{acct:username@hypothes.is}}

\item{permissions}{A named list with read, update, delete, and admin permissions. Defaults to setting global read permissions (\code{group:__world__}) and setting the \code{user} string for update, delete, and admin permissions.}

\item{document}{A list describing the document. CURRENTLY IGNORED.}

\item{target}{A list describing the highlight position of the annotation. CURRENTLY IGNORED}

\item{tags}{Character. (optional) Tags to apply to the annotation.}

\item{text}{Character. Text to put in the body of the annotation. This will be coerced into a character vector of length 1 using \link{paste}.}

\item{custom}{Add arbitrary fields to the JSON object submitted to hypothes.is by means of a named list.}
}
\value{
Upon successful creation, returns a 22-character annotation ID. This ID may be retrieved using \link{hs_read}.
}
\description{
Create annotations
}
\examples{
\dontrun{
hs_create(token = user_token,
uri = "https://github.com/mdlincoln/hypothesisr",
user = "acct:mdlincoln@hypothes.is", tags = c("testing", "R"),
text = "R made me!")
}
}

