% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statistics.R
\name{[.hstats_matrix}
\alias{[.hstats_matrix}
\title{Subsets "hstats_matrix" Object}
\usage{
\method{[}{hstats_matrix}(x, i, j, ...)
}
\arguments{
\item{x}{An object of class "hstats_matrix".}

\item{i}{Row subsetting.}

\item{j}{Column subsetting.}

\item{...}{Currently unused.}
}
\value{
A new object of class "hstats_matrix".
}
\description{
Use standard square bracket subsetting to select rows and/or columns of
statistics "M" (and "SE" in case of permutation importance statistics).
Implies \code{head()} and \code{tail()}.
}
\examples{
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
imp <- perm_importance(fit, X = iris, y = c("Sepal.Length", "Sepal.Width"))
head(imp, 1)
tail(imp, 2)
imp[1, "Sepal.Length"]
imp[1]
imp[, "Sepal.Width"]$SE
plot(imp[, "Sepal.Width"])
}
