% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_assign.R
\name{hexify_assign}
\alias{hexify_assign}
\title{Assign hex cells ('ISEA3H', aperture 3) for lon/lat}
\usage{
hexify_assign(
  lon,
  lat,
  effective_res,
  match_dggrid_parity = TRUE,
  make_polygons = FALSE
)
}
\arguments{
\item{lon, lat}{numeric vectors (same length), degrees.}

\item{effective_res}{integer effective resolution (>= 1).}

\item{match_dggrid_parity}{logical; TRUE matches 'ISEA3H' parity used by 'dggridR'.}

\item{make_polygons}{logical; if TRUE, return an sf with hex polygons.}
}
\value{
data.frame with id, face, effective_res, center_lon, center_lat;
if make_polygons=TRUE, an sf with geometry column.
}
\description{
Forward -> quantize (Z3) -> center (face) -> inverse to lon/lat.
Optionally return polygons (sf), in which case sf must be installed.
}
\keyword{internal}
