% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_quad_ij_to_xy}
\alias{hexify_quad_ij_to_xy}
\title{Convert Quad IJ to Quad XY (continuous coordinates)}
\usage{
hexify_quad_ij_to_xy(quad, i, j, resolution, aperture = 3L)
}
\arguments{
\item{quad}{Quad number (0-11)}

\item{i}{Cell index along first axis}

\item{j}{Cell index along second axis}

\item{resolution}{Grid resolution level}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
List with components:
\item{quad_x}{Continuous X coordinate in quad space}
\item{quad_y}{Continuous Y coordinate in quad space}
}
\description{
Converts discrete cell indices to continuous quad coordinates.
Useful for computing cell centers or understanding the cell geometry.
}
\examples{
# Get continuous quad coordinates for a cell
xy <- hexify_quad_ij_to_xy(quad = 1, i = 100, j = 50,
                           resolution = 10, aperture = 3)
print(xy)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
