% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoline.R
\name{isoline}
\alias{isoline}
\title{HERE Routing API: Isoline}
\usage{
isoline(poi, range = seq(5, 30, 5) * 60, rangetype = "time",
  type = "fastest", mode = "car", traffic = FALSE,
  departure = NULL, start = TRUE, aggregate = TRUE,
  url_only = FALSE)
}
\arguments{
\item{poi}{\code{sf} object, Points of Interest (POIs) of geometry type \code{POINT}.}

\item{range}{numeric, a vector of type \code{integer} containing the breaks for the generation of the isolines: (1) time in seconds; (2) distance in meters; (3) consumption in costfactor.}

\item{rangetype}{character, unit of the isolines: \code{"distance"}, \code{"time"} or \code{"consumption"}.}

\item{type}{character, set the routing type: \code{"fastest"} or \code{"shortest"}.}

\item{mode}{character, set the transport mode: \code{"car"}, \code{"pedestrian"} or \code{"truck"}.}

\item{traffic}{boolean, use real-time traffic or prediction in routing (\code{default = FALSE})? If no \code{departure} date and time is set, the current timestamp at the moment of the request is used for \code{departure}.}

\item{departure}{datetime, timestamp of type \code{POSIXct}, \code{POSIXt} for the departure.}

\item{start}{boolean, are the provided Points of Interest (POIs) the start or destination (\code{default = TRUE})?}

\item{aggregate}{boolean, aggregate (with function \code{min}) and intersect the isolines from geometry type \code{POLYGON} to geometry type \code{MULTIPOLYGON} (\code{default = TRUE})?}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
An \code{sf} object containing the requested isolines.
}
\description{
Calcuates isolines (\code{POLYGON} or \code{MULTIPOLYGON}) that connect the end points of all routes
leaving from defined centers (POIs) with either a specified length, a
specified travel time or consumption.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

# Isochrone for 5, 10, 15, 20, 25 and 30 minutes driving time
isolines <- isoline(
  poi = poi,
  range = seq(5, 30, 5) * 60,
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/routing/topics/resource-calculate-isoline.html}{HERE Routing API: Calculate Isoline}
}
