% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniStats.R
\name{uniStats}
\alias{uniStats}
\title{Univariate Test Statistics for a Multivariate Linear Model}
\usage{
uniStats(x, ...)
}
\arguments{
\item{x}{A \code{"mlm"} object fitted by \code{\link[stats]{lm}} with two or more response variables}

\item{...}{Other arguments, ignored}
}
\value{
An object of class \code{c("anova", "data.frame")} containing, for each response variable
        the overall \eqn{R^2} for all terms in the model and the overall \eqn{F} statistic
        together with its degrees of freedom and p-value.
}
\description{
Univariate Test Statistics for a Multivariate Linear Model
}
\examples{
iris.mod <- lm(cbind(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) ~ Species, data=iris)
car::Anova(iris.mod)
uniStats(iris.mod)

data(Plastic, package = "heplots")
plastic.mod <- lm(cbind(tear, gloss, opacity) ~ rate*additive, data=Plastic)
# multivariate tests
car::Anova(plastic.mod)
}
\seealso{
\code{\link{glance.mlm}}
}
