% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ADET}
\alias{ADET}
\title{Event-Time dataset for kidney outcomes.}
\format{
a data frame with 604 rows (events) and 6 variables:
\describe{
\item{ID}{patient identifiers, numeric}
\item{AVAL}{occurence time of the event, numeric}
\item{PARAM}{name of the event, character}
\item{PARAMCD}{coded name of the event, character}
\item{PARAMN}{type of the event, outcomes 1-7, where a higher value means a better outcome, numeric}
\item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
}
}
\source{
Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023).
}
\usage{
ADET
}
\description{
A dataset with multiple kidney outcomes over time scale outcomes of 1500 patients in the \code{ADSL} dataset.
}
\examples{
head(ADET)
# Number of unique patients
length(unique(ADET$ID)) 
# Number of events per event type
barplot(table(ADET$PARAM))
}
\keyword{datasets}
