% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hce.R
\name{hce}
\alias{hce}
\title{Helper function for the hce object}
\usage{
hce(AVAL = numeric(), TRTP = character())
}
\arguments{
\item{AVAL}{a numeric vector of analysis values.}

\item{TRTP}{a character vector of the same length as AVAL containing assigned treatment groups.}
}
\value{
an object of class hce. Its is a subject-level data frame (each row corresponds to one subject), containing the following columns:
\itemize{
\item SUBJID subject ID.
\item GROUP a character vector specifying the type of the outcome the patient experienced - either a TTE (time-to-event) or C (continuous).
\item GROUPN a numeric vector version of the \code{GROUP} column.
\item AVAL0 original analysis values - time of the time-to-event outcomes or the continuous outcome.
\item AVAL derived analysis value \code{AVAL = AVAL0 + GROUPN}.
\item TRTP assigned treatment groups.
}
}
\description{
Helper function for the hce object
}
\examples{
set.seed(2022)
d <- hce(AVAL = c(rnorm(5, mean = 1), rnorm(5)), TRTP = rep(c("A", "P"), each = 5))
calcWO(d)
}
\seealso{
\code{\link[=new_hce]{new_hce()}}, \code{\link[=validate_hce]{validate_hce()}}  for the helper and validator functions of hce.
}
