% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFit.R
\name{printFit}
\alias{printFit}
\title{Print model-fits (mean LOOIC or WAIC values in addition to Akaike weights) of hBayesDM Models}
\usage{
printFit(..., ic = "looic", ncore = 2, roundTo = 3)
}
\arguments{
\item{...}{Model objects output by hBayesDM functions (e.g. output1, output2, etc.)}

\item{ic}{Which model comparison information criterion to use? 'looic', 'waic', or 'both}

\item{ncore}{Number of corse to use when computing LOOIC}

\item{roundTo}{Number of digits to the right of the decimal point in the output}
}
\value{
modelTable A table with relevant model comparison data. LOOIC and WAIC weights are computed as Akaike weights.
}
\description{
Print model-fits (mean LOOIC or WAIC values in addition to Akaike weights) of hBayesDM Models
}
\examples{
\dontrun{
# Run two models and store results in "output1" and "output2"
output1 <- dd_hyperbolic("example", 2000, 1000, 3, 3)

output2 <- dd_exp("example", 2000, 1000, 3, 3)

# Show the LOOIC model fit estimates
printFit(output1, output2)

# To show the WAIC model fit estimates
printFit(output1, output2, ic = "waic")

# To show both LOOIC and WAIC
printFit(output1, output2, ic = "both")
}
}
