% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_columns.R
\name{summary_columns}
\alias{summary_columns}
\title{Add summary columns using aggregation functions}
\usage{
summary_columns(
  data,
  columns = everything(),
  fns = NULL,
  new_col_names = NULL,
  new_col_labels = NULL,
  fmt = NULL,
  side = c("right", "left"),
  missing_text = "---"
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to aggregate}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns to aggregate across for each row. Can either be a series of
column names provided in \code{c()}, a vector of column indices, or a select
helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}},
\code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}).}

\item{fns}{\emph{Aggregation Expression(s)}

\verb{<expression|list of expressions>}

One or more functions used for aggregation. For a single summary column,
provide a single function as a formula (e.g., \code{~ sum(.)}), character
string (e.g., \code{"sum"}), or bare function (e.g., \code{sum}). For multiple
summary columns, provide a list of formulas (e.g.,
\code{list(~ sum(.), ~ mean(.), ~ sd(.))}). Base functions like \code{mean}, \code{min},
\code{max}, \code{median}, \code{sd}, and \code{sum} are supported, along with any
user-defined aggregation functions.}

\item{new_col_names}{\emph{Names for new summary columns}

\verb{vector<character>} // \emph{default:} \code{NULL}

Optional names for the new summary columns. Can provide one name for a
single summary column, or multiple names (must match the length of \code{fns})
when adding multiple columns. These names are used as column identifiers
for targeting in other \strong{gt} functions (e.g., \code{\link[=fmt_number]{fmt_number()}},
\code{\link[=tab_style]{tab_style()}}). If \code{NULL}, names will be generated from the function
expressions (e.g., \code{"sum"}, \code{"mean"}) or default to \code{"summary_1"},
\code{"summary_2"}, etc.}

\item{new_col_labels}{\emph{Labels for new summary columns}

\verb{list|vector<character>} // \emph{default:} \code{NULL}

Optional labels for the new summary column headers. Can provide one label
for a single column, or multiple labels (must match the length of \code{fns})
when adding multiple columns. Can include plain text or use \code{\link[=md]{md()}} or
\code{\link[=html]{html()}} helpers. If \code{NULL}, will use \code{new_col_names} as labels.
\strong{Important}: Use \code{list()} instead of \code{c()} when mixing plain text with
\code{\link[=md]{md()}} or \code{\link[=html]{html()}} objects to preserve their classes (e.g.,
\code{list("Total", md("**Average**"))}).}

\item{fmt}{\emph{Formatting expression}

\verb{<expression>}

An optional formatting expression in formula form. The RHS of \code{~} should
contain a formatting call (e.g., \code{~ fmt_number(., decimals = 2)}).}

\item{side}{\emph{Side used for placement of summary column}

\verb{singl-kw:[right|left]} // \emph{default:} \code{"right"}

Should the summary column be placed on the \code{"right"} (the default) or the
\code{"left"} side of the table?}

\item{missing_text}{\emph{Replacement text for \code{NA} values}

\verb{scalar<character>} // \emph{default:} \code{"---"}

The text to be used in place of \code{NA} values in the summary column cells.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{summary_columns()} function adds one or more computed columns to a table
by aggregating values across selected columns within each row. This is the
horizontal counterpart to \code{\link[=summary_rows]{summary_rows()}}, which aggregates down columns to
create summary rows. Common use cases include calculating row totals, row
averages, or other row-wise statistics.

Summary columns are computed immediately when the function is called and are
added to the table's data as regular columns. This means they can be
referenced in subsequent \strong{gt} operations like \code{\link[=cols_move]{cols_move()}}, \code{\link[=fmt_number]{fmt_number()}},
\code{\link[=tab_style]{tab_style()}}, or even in other computed columns via \code{\link[=cols_add]{cols_add()}}.

You can create a single summary column or multiple columns at once by
providing a list of aggregation functions. The functions can be any R
expression that takes a vector of values and returns a single value (like
\code{sum()}, \code{mean()}, \code{max()}, \code{min()}, etc.). Column names and labels can be
auto-generated from function names or explicitly specified.
}
\section{Examples}{


Use a subset of the \code{\link{countrypops}} dataset to create a \strong{gt} table. Add a
summary column that computes the average annual change using
\code{summary_columns()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  arrange(country_name, year) |>
  group_by(country_name, country_code_2) |>
  summarize(
    pop_1960 = first(population),
    pop_2024 = last(population),
    years = n(),
    .groups = "drop"
  ) |>
  filter(!is.na(pop_1960), !is.na(pop_2024)) |>
  mutate(total_change = pop_2024 - pop_1960) |>
  slice_max(total_change, n = 5) |>
  select(country_name, country_code_2, pop_1960, pop_2024, years) |>
  gt() |>
  summary_columns(
    columns = c(pop_1960, pop_2024, years),
    fns = ~ (.[2] - .[1]) / (.[3] - 1),
    new_col_names = "avg_annual_change",
    new_col_labels = md("**Avg. Annual Change**")  # No list() needed!
  ) |>
  cols_hide(columns = c(pop_1960, pop_2024, years)) |>
  fmt_integer() |>
  cols_label(
    country_name = "Country",
    country_code_2 = "Code"
  ) |>
  tab_header(
    title = "Top 5 Countries by Population Growth",
    subtitle = "Average annual population change (1960-2024)"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_summary_columns_1.png" alt="This image of a table was generated from the first code example in the `summary_columns()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

6-4
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other row addition/modification functions: 
\code{\link{grand_summary_rows}()},
\code{\link{row_group_order}()},
\code{\link{rows_add}()},
\code{\link{summary_rows}()}
}
\concept{row addition/modification functions}
