% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiweek-scale.R
\name{scale_x_grates_epiweek}
\alias{scale_x_grates_epiweek}
\title{Epiweek scale}
\usage{
scale_x_grates_epiweek(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  format = NULL
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_epiweek>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{format}{Format to use if "Date" scales are required.

If NULL (default) then labels are in the standard epiweek format (YYYY-Wxx).

If "week" then the labels are of the form Www (e.g. W37).

Otherwise the value is used by \code{format.Date()} and can be any input
acceptable by that function.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for an \verb{<grates_epiweek>} vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist
x <- as_epiweek(linelist$date_of_infection)
dat <- aggregate(list(cases = x), by = list(week = x), FUN = length)

# plot the output
(week_plot <-
    ggplot2::ggplot(dat, ggplot2::aes(week, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw())

# We can have non-centred date labels on the x_axis by using the
# associated scale function and explicitly specifying a format for
# the date labels:
week_plot + scale_x_grates_epiweek(format = "\%Y-\%m-\%d")
\dontshow{\}) # examplesIf}
}
