% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{DESeq2BIC}
\alias{DESeq2BIC}
\title{Compute the Bayesian information criterion (BIC)}
\usage{
DESeq2BIC(
  data,
  name = "BIC",
  mode = "total",
  normalization = mode,
  formulas = list(Condition = ~Condition, Background = ~1),
  no4sU = FALSE,
  columns = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data}{A grandR object}

\item{name}{the user defined analysis name to store the results}

\item{mode}{either "total", "new" or "old"}

\item{normalization}{normalize on "total", "new", or "old" (see details)}

\item{formulas}{list of formulas specifying the models (you can use any column name from the \code{\link{Coldata}(data)})}

\item{no4sU}{Use no4sU columns (TRUE) or not (FALSE)}

\item{columns}{logical vector of which columns (samples or cells) to use (or NULL: use all)}

\item{verbose}{Print status updates}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are named as <name in list>.dBIC
}
\description{
Compute the delta BIC for a list of potential models
}
\details{
DESeq2 by default performs size factor normalization. When computing differential expression of new RNA,
it might be sensible to normalize w.r.t. to total RNA, i.e. use the size factors computed from total RNA instead of computed from new RNA.
This can be accomplished by setting mode to "new", and normalization to "total"!
}
\concept{diffexp}
