% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-vclMatrix.R
\docType{class}
\name{vclMatrix-class}
\alias{vclMatrix-class}
\title{vclMatrix Class}
\value{
An object of class 'vclMatrix' with the specified slots.
}
\description{
This is the 'mother' class for all
vclMatrix objects.  These objects are pointers
to viennacl matrices directly on the GPU.  This will 
avoid the overhead of passing data back and forth 
between the host and device.

As such, any changes made
to normal R 'copies' (e.g. A <- B) will be propogated to
the parent object.

There are multiple child classes that correspond
to the particular data type contained.  These include
\code{ivclMatrix}, \code{fvclMatrix}, and 
\code{dvclMatrix} corresponding to integer, float, and
double data types respectively.
}
\note{
R does not contain a native float type.  As such,
the matrix data within a \code{\link{fvclMatrix-class}} 
will be represented as double but downcast when any 
vclMatrix methods are used.

May also remove the type slot
}
\section{Slots}{

 Common to all vclMatrix objects in the package
 \describe{
     \item{\code{address}:}{Pointer to data matrix}
     \item{\code{.context_index}:}{Integer index of OpenCL contexts}
     \item{\code{.platform_index}:}{Integer index of OpenCL platforms}
     \item{\code{.platform}:}{Name of OpenCL platform}
     \item{\code{.device_index}:}{Integer index of active device}
     \item{\code{.device}:}{Name of active device}
 }
}

\seealso{
\code{\link{ivclMatrix-class}}, 
\code{\link{fvclMatrix-class}},
\code{\link{dvclMatrix-class}}
}
\author{
Charles Determan Jr.
}
