% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{maxNObs}
\alias{maxNObs}
\title{Maximum Number of Observations per Person}
\usage{
maxNObs(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
Maximum number of observations as a numeric.
}
\description{
Extracts the maximum number of observations per person from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
maxNumberObs <- maxNObs(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
