% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{goose_template}
\alias{goose_template}
\title{Create a Prompt Template}
\usage{
goose_template(
  name,
  template,
  description = NULL,
  variables = NULL,
  examples = NULL
)
}
\arguments{
\item{name}{Template name}

\item{template}{Template text with \{variable\} placeholders}

\item{description}{Optional description}

\item{variables}{List of variable definitions}

\item{examples}{Optional usage examples}
}
\value{
Template object
}
\description{
Define a reusable prompt template with variables
}
\examples{
\dontrun{
# Create a code review template
review_template <- goose_template(
  name = "code_review",
  template = "Review this {language} code:\n\n{code}\n\nFocus on: {focus}",
  variables = list(
    language = "Programming language",
    code = "Code to review",
    focus = "Specific areas to focus on"
  )
)
}
}
