% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{gmfd_diss}
\alias{gmfd_diss}
\title{Dissimilarity matrix function}
\usage{
gmfd_diss(FD, metric, p = NULL, k_trunc = NULL)
}
\arguments{
\item{FD}{a functional data object of type \code{funData}}

\item{metric}{the chosen distance to be used. Choose \code{"L2"} for the classical L2-distance, \code{"trunc"} for the truncated Mahalanobis semi-distance, \code{"mahalanobis"} for the generalized Mahalanobis distance.}

\item{p}{a positive numeric value containing the parameter of the regularizing function for the generalized Mahalanobis distance.}

\item{k_trunc}{a positive numeric value representing the number of components at which the truncated mahalanobis distance must be truncated}
}
\value{
The function returns a matrix of numeric values containing the distances between the curves.
}
\description{
This function computes the dissimilarity matrix containing the distances between the curves of the functional dataset
}
\examples{
# Define parameters
n <- 50
P <- 100
K <- 150

# Grid of the functional dataset
t <- seq( 0, 1, length.out = P )

# Define the means and the parameters to use in the simulation
m1 <- t^2 * ( 1 - t )

rho <- rep( 0, K )
theta <- matrix( 0, K, P )
for ( k in 1:K ) {
  rho[k] <- 1 / ( k + 1 )^2
  if ( k\%\%2 == 0 )
    theta[k, ] <- sqrt( 2 ) * sin( k * pi * t )
  else if ( k\%\%2 != 0 && k != 1 )
    theta[k, ] <- sqrt( 2 ) * cos( ( k - 1 ) * pi * t )
  else
    theta[k, ] <- rep( 1, P )
}

# Simulate the functional data
x <- gmfd_simulate( n, m1, rho = rho, theta = theta )

FD <- funData( t, x )

D <- gmfd_diss( FD, metric = "L2" )
}
\references{
Ghiglietti A., Ieva F., Paganoni A. M. (2017). Statistical inference for stochastic processes:
Two-sample hypothesis tests, \emph{Journal of Statistical Planning and Inference}, 180:49-68.

Ghiglietti A., Paganoni A. M. (2017). Exact tests for the means of gaussian stochastic processes.
\emph{Statistics & Probability Letters}, 131:102--107.
}
