% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funData.R
\name{plot.funData}
\alias{plot.funData}
\title{A method to plot \code{funData} objects}
\usage{
\method{plot}{funData}(x, ...)
}
\arguments{
\item{x}{the univariate functional dataset in form of \code{funData} object.}

\item{...}{additional graphical parameters to be used in plotting functions}
}
\description{
This function performs the plot of a functional dataset stored in
an object of class \code{funData}.
}
\examples{
# Define parameters
n <- 50
P <- 100
K <- 150

# Grid of the functional dataset
t <- seq( 0, 1, length.out = P )

# Define the means and the parameters to use in the simulation
m1 <- t^2 * ( 1 - t )
m2 <- t * ( 1 - t )^2

rho <- rep( 0, K )
theta <- matrix( 0, K, P )
for ( k in 1:K) {
  rho[k] <- 1 / ( k + 1 )^2
  if ( k\%\%2 == 0 )
    theta[k, ] <- sqrt( 2 ) * sin( k * pi * t )
  else if ( k\%\%2 != 0 && k != 1 )
    theta[k, ] <- sqrt( 2 ) * cos( ( k - 1 ) * pi * t )
  else
    theta[k, ] <- rep( 1, P )
}
# Simulate the functional data
x1 <- gmfd_simulate( n, m1, rho = rho, theta = theta )
x2 <- gmfd_simulate( n, m2, rho = rho, theta = theta )

FD <- funData( t, list( x1, x2 ) )

plot(FD)
}
\seealso{
\code{\link{funData}}
}
