% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{logLik.gkwfit}
\alias{logLik.gkwfit}
\title{Extract Log-Likelihood from a gkwfit Object}
\usage{
\method{logLik}{gkwfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwfit"}, typically the result of a call to \code{\link{gkwfit}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{"logLik"}. This is the numeric log-likelihood value
with the following attributes:
\item{df}{The number of estimated parameters in the model (integer).}
\item{nobs}{The number of observations used for fitting the model (integer).}
}
\description{
Extracts the maximized log-likelihood value from a model fitted by \code{\link{gkwfit}}.
It returns an object of class \code{"logLik"}, which includes attributes for the
degrees of freedom (\code{"df"}) and the number of observations (\code{"nobs"}) used in the fit.
}
\details{
This method provides compatibility with standard R functions that operate on
log-likelihood values, such as \code{\link[stats]{AIC}}, \code{\link[stats]{BIC}},
and likelihood ratio tests. It retrieves the log-likelihood stored during the
model fitting process (in \code{object$loglik}) and attaches the required
attributes (\code{object$df} for the number of estimated parameters and
\code{object$nobs} for the number of observations).
}
\examples{
\donttest{
# Generate data and fit two models
set.seed(2203)
y <- rgkw(50, alpha = 2, beta = 3, gamma = 1, delta = 0, lambda = 1.5)

fit1 <- gkwfit(data = y, family = "kkw", plot = FALSE) # KKw model
fit2 <- gkwfit(data = y, family = "ekw", plot = FALSE) # EKw model

# Extract log-likelihood values
ll1 <- logLik(fit1)
ll2 <- logLik(fit2)

print(ll1)
print(ll2)

# Use for likelihood ratio test
lr_stat <- -2 * (as.numeric(ll1) - as.numeric(ll2))
df_diff <- attr(ll1, "df") - attr(ll2, "df")
p_value <- pchisq(lr_stat, df = abs(df_diff), lower.tail = FALSE)

cat("LR statistic:", lr_stat, "\n")
cat("df:", df_diff, "\n")
cat("p-value:", p_value, "\n")
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link[stats]{AIC}}, \code{\link[stats]{BIC}}, \code{\link[stats]{logLik}}
}
\author{
Lopes, J. E.
}
\keyword{methods}
\keyword{models}
\keyword{utility}
