% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_countries_2024}
\alias{gisco_countries_2024}
\title{Countries 2024 \code{\link[sf:sf]{sf}} object}
\format{
A \code{\link[sf:sf]{sf}} object with \code{MULTIPOLYGON} geometries, resolution:
1:20 million and \href{https://epsg.io/4326}{EPSG:4326}. with
263 rows and 12 variables:
\describe{
\item{\code{CNTR_ID}}{Country ID as per Eurostat.}
\item{\code{CNTR_NAME}}{Official country name on local language.}
\item{\code{NAME_ENGL}}{Country name in English.}
\item{\code{NAME_FREN}}{Country name in French.}
\item{\code{ISO3_CODE}}{ISO 3166-1 alpha-3 code of each country, as provided by
GISCO.}
\item{\code{SVRG_UN}}{Sovereign status as per United Nations.}
\item{\code{CAPT}}{Capitol city.}
\item{\code{EU_STAT}}{European Union member.}
\item{\code{EFTA_STAT}}{EFTA member.}
\item{\code{CC_STAT}}{EU candidate member.}
\item{\code{NAME_GERM}}{Country name in German.}
\item{\code{geometry}}{geometry field.}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/countries/gpkg/}{CNTR_RG_20M_2024_4326.gpkg} file.
}
\description{
This object contains the administrative boundaries at country level of the
world.
}
\examples{

data("gisco_countries_2024")
head(gisco_countries_2024)

}
\seealso{
\code{\link[=gisco_get_countries]{gisco_get_countries()}}

Other datasets: 
\code{\link{gisco_coastal_lines}},
\code{\link{gisco_countrycode}},
\code{\link{gisco_db}},
\code{\link{gisco_nuts_2024}}
}
\concept{datasets}
