% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peddown.R
\name{peddown}
\alias{peddown}
\title{Downward pedigree extraction}
\usage{
peddown(ped, parents)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{parents}{: Vector of animal(s), from which the new pedigree is being extracted.}
}
\value{
newped : Extracted pedigree \code{data.frame}
}
\description{
Extract pedigree downward for one or a group of animals to find their descendants
}
\examples{
ped = data.frame(ID=1:6, SIRE=c(0,0,1,3,1,4), DAM=c(0,0,2,2,2,5))
peddown(ped, c(1,4))

}
