##' convert plot to ggplot object
##'
##'
##' @title as.ggplot
##' @param plot base or grid plot, or graphic generated by ggplot, lattice, etc.
##' @param scale scale of the plot to be drawn
##' @importFrom ggplot2 ggplot
##' @importFrom ggplot2 aes_
##' @importFrom ggplot2 geom_blank
##' @importFrom ggplot2 annotation_custom
##' @importFrom ggplot2 theme_void
##' @importFrom ggplot2 scale_x_continuous
##' @importFrom ggplot2 scale_y_continuous
##' @return ggplot object
##' @export
##' @examples
##' as.ggplot(~barplot(1:10))
##' @author Guangchuang Yu
as.ggplot <- function(plot, scale = 1) {
    ## plot_expr <- quo_name(enexpr(plot))
    ## if (is.null(plot)) {
    ##     plot <- as.grob(plot_expr)
    ## }

    ymin <- xmin <- 1 - scale
    xmax <- ymax <- scale

    ggplot(data.frame(x = 0:1, y = 0:1), aes_(x = ~x, y = ~y)) +
        geom_blank() +
        scale_x_continuous(limits = c(0,1), expand = c(0, 0)) +
        scale_y_continuous(limits = c(0,1), expand = c(0, 0)) +
        annotation_custom(as.grob(plot),
                          xmin = xmin,
                          xmax = xmax,
                          ymin = ymin,
                          ymax = ymax)  +
        theme_void()
}

