% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-construction.R
\name{add_gg}
\alias{add_gg}
\alias{+.gg}
\alias{\%+\%}
\title{Add components to a plot}
\usage{
add_gg(e1, e2)

e1 \%+\% e2
}
\arguments{
\item{e1}{An object of class \code{\link[=ggplot]{ggplot()}} or a \code{\link[=theme]{theme()}}.}

\item{e2}{A plot component, as described below.}
}
\description{
\code{+} is the key to constructing sophisticated ggplot2 graphics. It
allows you to start simple, then get more and more complex, checking your
work at each step.
}
\section{What can you add?}{

You can add any of the following types of objects:
\itemize{
\item An \code{\link[=aes]{aes()}} object replaces the default aesthetics.
\item A layer created by a \code{geom_} or \code{stat_} function adds a
new layer.
\item A \code{scale} overrides the existing scale.
\item A \code{\link[=theme]{theme()}} modifies the current theme.
\item A \code{coord} overrides the current coordinate system.
\item A \code{facet} specification overrides the current faceting.
}

To replace the current default data frame, you must use \verb{\%+\%},
due to S3 method precedence issues.

You can also supply a list, in which case each element of the list will
be added in turn.
}

\examples{
base <-
 ggplot(mpg, aes(displ, hwy)) +
 geom_point()
base + geom_smooth()

# To override the data, you must use \%+\%
base \%+\% subset(mpg, fl == "p")

# Alternatively, you can add multiple components with a list.
# This can be useful to return from a function.
base + list(subset(mpg, fl == "p"), geom_smooth())
}
\seealso{
\code{\link[=theme]{theme()}}
}
