% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-steps.R, R/zxx.r
\name{scale_colour_steps}
\alias{scale_colour_steps}
\alias{scale_colour_steps2}
\alias{scale_colour_stepsn}
\alias{scale_fill_steps}
\alias{scale_fill_steps2}
\alias{scale_fill_stepsn}
\alias{scale_color_steps}
\alias{scale_color_steps2}
\alias{scale_color_stepsn}
\title{Binned gradient colour scales}
\usage{
scale_colour_steps(
  ...,
  low = "#132B43",
  high = "#56B1F7",
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour"
)

scale_colour_steps2(
  ...,
  low = muted("red"),
  mid = "white",
  high = muted("blue"),
  midpoint = 0,
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour"
)

scale_colour_stepsn(
  ...,
  colours,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour",
  colors
)

scale_fill_steps(
  ...,
  low = "#132B43",
  high = "#56B1F7",
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "fill"
)

scale_fill_steps2(
  ...,
  low = muted("red"),
  mid = "white",
  high = muted("blue"),
  midpoint = 0,
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "fill"
)

scale_fill_stepsn(
  ...,
  colours,
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "fill",
  colors
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=binned_scale]{binned_scale}}
  \describe{
    \item{\code{n.breaks}}{The number of break points to create if breaks are not given
directly.}
    \item{\code{nice.breaks}}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicetly.}
    \item{\code{right}}{Should values on the border between bins be part of the right
(upper) bin?}
    \item{\code{show.limits}}{should the limits of the scale appear as ticks}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:extended_breaks]{scales::extended_breaks()}})
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[=coord_cartesian]{coord_cartesian()}}).
}}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds).
\item The default (\code{\link[scales:censor]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:squish]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:squish_infinite]{scales::squish_infinite()}} for squishing infitite values into range.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{trans}}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{<name>_trans} (e.g.,
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}). You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{low}{Colours for low and high ends of the gradient.}

\item{high}{Colours for low and high ends of the gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{mid}{colour for mid point}

\item{midpoint}{The midpoint (in data value) of the diverging scale.
Defaults to 0.}

\item{colours}{Vector of colours to use for n-colour gradient.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[scales:rescale]{rescale()}} for a convenience function
to map an arbitrary range to between 0 and 1.}

\item{colors}{Vector of colours to use for n-colour gradient.}
}
\description{
\verb{scale_*_steps} creates a two colour binned gradient (low-high),
\verb{scale_*_steps2} creates a diverging binned colour gradient (low-mid-high),
and \verb{scale_*_stepsn} creates a n-colour binned gradient. These scales are
binned variants of the \link[=scale_colour_gradient]{gradient scale} family and
works in the same way.
}
\details{
Default colours are generated with \pkg{munsell} and
\code{mnsl(c("2.5PB 2/4", "2.5PB 7/10"))}. Generally, for continuous
colour scales you want to keep hue constant, but vary chroma and
luminance. The \pkg{munsell} package makes this easy to do using the
Munsell colour system.
}
\examples{
df <- data.frame(
  x = runif(100),
  y = runif(100),
  z1 = rnorm(100)
)

# Use scale_colour_steps for a standard binned gradient
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_steps()

# Get a divergent binned scale with the *2 variant
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_steps2()

# Define your own colour ramp to extract binned colours from
ggplot(df, aes(x, y)) +
  geom_point(aes(colour = z1)) +
  scale_colour_stepsn(colours = terrain.colors(10))
}
\seealso{
\code{\link[scales:seq_gradient_pal]{scales::seq_gradient_pal()}} for details on underlying
palette

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
