% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-.r, R/geom-.r, R/annotation-custom.r,
%   R/annotation-logticks.r, R/geom-polygon.r, R/geom-map.r, R/annotation-map.r,
%   R/geom-raster.r, R/annotation-raster.r, R/axis-secondary.R, R/coord-.r,
%   R/coord-cartesian-.r, R/coord-fixed.r, R/coord-flip.r, R/coord-map.r,
%   R/coord-polar.r, R/coord-quickmap.R, R/coord-transform.r, R/facet-.r,
%   R/facet-grid-.r, R/facet-null.r, R/facet-wrap.r, R/stat-.r, R/geom-abline.r,
%   R/geom-rect.r, R/geom-bar.r, R/geom-blank.r, R/geom-boxplot.r, R/geom-col.r,
%   R/geom-path.r, R/geom-contour.r, R/geom-crossbar.r, R/geom-segment.r,
%   R/geom-curve.r, R/geom-ribbon.r, R/geom-density.r, R/geom-density2d.r,
%   R/geom-dotplot.r, R/geom-errorbar.r, R/geom-errorbarh.r, R/geom-hex.r,
%   R/geom-hline.r, R/geom-label.R, R/geom-linerange.r, R/geom-point.r,
%   R/geom-pointrange.r, R/geom-quantile.r, R/geom-rug.r, R/geom-smooth.r,
%   R/geom-spoke.r, R/geom-text.r, R/geom-tile.r, R/geom-violin.r,
%   R/geom-vline.r, R/layout.R, R/position-.r, R/position-dodge.r,
%   R/position-dodge2.r, R/position-identity.r, R/position-jitter.r,
%   R/position-jitterdodge.R, R/position-nudge.R, R/position-stack.r,
%   R/scale-.r, R/scale-continuous.r, R/scale-date.r, R/scale-discrete-.r,
%   R/scale-identity.r, R/stat-bin.r, R/stat-bin2d.r, R/stat-bindot.r,
%   R/stat-binhex.r, R/stat-boxplot.r, R/stat-contour.r, R/stat-count.r,
%   R/stat-density-2d.r, R/stat-density.r, R/stat-ecdf.r, R/stat-ellipse.R,
%   R/stat-function.r, R/stat-identity.r, R/stat-qq-line.R, R/stat-qq.r,
%   R/stat-quantile.r, R/stat-smooth.r, R/stat-sum.r, R/stat-summary-2d.r,
%   R/stat-summary-bin.R, R/stat-summary-hex.r, R/stat-summary.r,
%   R/stat-unique.r, R/stat-ydensity.r
\docType{data}
\name{ggplot2-ggproto}
\alias{ggplot2-ggproto}
\alias{Geom}
\alias{GeomCustomAnn}
\alias{GeomLogticks}
\alias{GeomPolygon}
\alias{GeomMap}
\alias{GeomAnnotationMap}
\alias{GeomRaster}
\alias{GeomRasterAnn}
\alias{AxisSecondary}
\alias{Coord}
\alias{CoordCartesian}
\alias{CoordFixed}
\alias{CoordFlip}
\alias{CoordMap}
\alias{CoordPolar}
\alias{CoordQuickmap}
\alias{CoordTrans}
\alias{Facet}
\alias{FacetGrid}
\alias{FacetNull}
\alias{FacetWrap}
\alias{Stat}
\alias{GeomAbline}
\alias{GeomRect}
\alias{GeomBar}
\alias{GeomBlank}
\alias{GeomBoxplot}
\alias{GeomCol}
\alias{GeomPath}
\alias{GeomLine}
\alias{GeomStep}
\alias{GeomContour}
\alias{GeomCrossbar}
\alias{GeomSegment}
\alias{GeomCurve}
\alias{GeomRibbon}
\alias{GeomArea}
\alias{GeomDensity}
\alias{GeomDensity2d}
\alias{GeomDotplot}
\alias{GeomErrorbar}
\alias{GeomErrorbarh}
\alias{GeomHex}
\alias{GeomHline}
\alias{GeomLabel}
\alias{GeomLinerange}
\alias{GeomPoint}
\alias{GeomPointrange}
\alias{GeomQuantile}
\alias{GeomRug}
\alias{GeomSmooth}
\alias{GeomSpoke}
\alias{GeomText}
\alias{GeomTile}
\alias{GeomViolin}
\alias{GeomVline}
\alias{Layout}
\alias{Position}
\alias{PositionDodge}
\alias{PositionDodge2}
\alias{PositionIdentity}
\alias{PositionJitter}
\alias{PositionJitterdodge}
\alias{PositionNudge}
\alias{PositionStack}
\alias{PositionFill}
\alias{Scale}
\alias{ScaleContinuous}
\alias{ScaleDiscrete}
\alias{ScaleContinuousPosition}
\alias{ScaleContinuousDatetime}
\alias{ScaleContinuousDate}
\alias{ScaleDiscretePosition}
\alias{ScaleDiscreteIdentity}
\alias{ScaleContinuousIdentity}
\alias{StatBin}
\alias{StatBin2d}
\alias{StatBindot}
\alias{StatBinhex}
\alias{StatBoxplot}
\alias{StatContour}
\alias{StatCount}
\alias{StatDensity2d}
\alias{StatDensity}
\alias{StatEcdf}
\alias{StatEllipse}
\alias{StatFunction}
\alias{StatIdentity}
\alias{StatQqLine}
\alias{StatQq}
\alias{StatQuantile}
\alias{StatSmooth}
\alias{StatSum}
\alias{StatSummary2d}
\alias{StatSummaryBin}
\alias{StatSummaryHex}
\alias{StatSummary}
\alias{StatUnique}
\alias{StatYdensity}
\title{Base ggproto classes for ggplot2}
\description{
If you are creating a new geom, stat, position, or scale in another package,
you'll need to extend from \code{ggplot2::Geom}, \code{ggplot2::Stat},
\code{ggplot2::Position}, or \code{ggplot2::Scale}.
}
\section{Geoms}{


All \code{geom_*} functions (like \code{geom_point}) return a layer that
contains a \code{Geom*} object (like \code{GeomPoint}). The \code{Geom*}
object is responsible for rendering the data in the plot.

Each of the \code{Geom*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Geom}, and each implements various methods and
fields.

Compared to \code{Stat} and \code{Position}, \code{Geom} is a little
different because the execution of the setup and compute functions is
split up. \code{setup_data} runs before position adjustments, and
\code{draw_layer} is not run until render time, much later. This
means there is no \code{setup_params} because it's hard to communicate
the changes.

To create a new type of Geom object, you typically will want to
override one or more of the following:
\itemize{
\item Either \code{draw_panel(self, data, panel_params, coord)} or
\code{draw_group(self, data, panel_params, coord)}. \code{draw_panel} is
called once per panel, \code{draw_group} is called once per group.

Use \code{draw_panel} if each row in the data represents a
single element. Use \code{draw_group} if each group represents
an element (e.g. a smooth, a violin).

\code{data} is a data frame of scaled aesthetics.

\code{panel_params} is a set of per-panel parameters for the
\code{coord}. Generally, you should consider \code{panel_params}
to be an opaque data structure that you pass along whenever you call
a coord method.

You must always call \code{coord$transform(data, panel_params)} to
get the (position) scaled data for plotting. To work with
non-linear coordinate systems, you typically need to convert into a
primitive geom (e.g. point, path or polygon), and then pass on to the
corresponding draw method for munching.

Must return a grob. Use \code{\link[=zeroGrob]{zeroGrob()}} if there's nothing to
draw.
\item \code{draw_key}: Renders a single legend key.
\item \code{required_aes}: A character vector of aesthetics needed to
render the geom.
\item \code{default_aes}: A list (generated by \code{\link[=aes]{aes()}} of
default values for aesthetics.
\item \code{setup_data}: Converts width and height to xmin and xmax,
and ymin and ymax values. It can potentially set other values as well.
}
}

\section{Coordinate systems}{


All \code{coord_*} functions (like \code{coord_trans}) return a \code{Coord*}
object (like \code{CoordTrans}).

Each of the \code{Coord*} objects is a \code{\link[=ggproto]{ggproto()}} object,
descended from the top-level \code{Coord}.  To create a new type of Coord
object, you typically will want to implement one or more of the following:
\itemize{
\item \code{aspect}: Returns the desired aspect ratio for the plot.
\item \code{labels}: Returns a list containing labels for x and y.
\item \code{render_fg}: Renders foreground elements.
\item \code{render_bg}: Renders background elements.
\item \code{render_axis_h}: Renders the horizontal axes.
\item \code{render_axis_v}: Renders the vertical axes.
\item \code{backtransform_range(panel_params)}: Extracts the panel range provided
in \code{panel_params} (created by \code{setup_panel_params()}, see below) and
back-transforms to data coordinates. This back-transformation can be needed
for coords such as \code{coord_trans()} where the range in the transformed
coordinates differs from the range in the untransformed coordinates. Returns
a list of two ranges, \code{x} and \code{y}, and these correspond to the variables
mapped to the \code{x} and \code{y} aesthetics, even for coords such as \code{coord_flip()}
where the \code{x} aesthetic is shown along the y direction and vice versa.
\item \code{range(panel_params)}: Extracts the panel range provided
in \code{panel_params} (created by \code{setup_panel_params()}, see below) and
returns it. Unlike \code{backtransform_range()}, this function does not perform
any back-transformation and instead returns final transformed coordinates. Returns
a list of two ranges, \code{x} and \code{y}, and these correspond to the variables
mapped to the \code{x} and \code{y} aesthetics, even for coords such as \code{coord_flip()}
where the \code{x} aesthetic is shown along the y direction and vice versa.
\item \code{transform}: Transforms x and y coordinates.
\item \code{distance}: Calculates distance.
\item \code{is_linear}: Returns \code{TRUE} if the coordinate system is
linear; \code{FALSE} otherwise.
\item \code{is_free}: Returns \code{TRUE} if the coordinate system supports free
positional scales; \code{FALSE} otherwise.
\item \code{setup_panel_params(scale_x, scale_y, params)}: Determines the appropriate
x and y ranges for each panel, and also calculates anything else needed to
render the panel and axes, such as tick positions and labels for major
and minor ticks. Returns all this information in a named list.
\item \code{setup_data(data, params)}: Allows the coordinate system to
manipulate the plot data. Should return list of data frames.
\item \code{setup_layout(layout, params)}: Allows the coordinate
system to manipulate the \code{layout} data frame which assigns
data to panels and scales.
}
}

\section{Facets}{


All \code{facet_*} functions returns a \code{Facet} object or an object of a
\code{Facet} subclass. This object describes how to assign data to different
panels, how to apply positional scales and how to lay out the panels, once
rendered.

Extending facets can range from the simple modifications of current facets,
to very laborious rewrites with a lot of \code{\link[=gtable]{gtable()}} manipulation.
For some examples of both, please see the extension vignette.

\code{Facet} subclasses, like other extendible ggproto classes, have a range
of methods that can be modified. Some of these are required for all new
subclasses, while other only need to be modified if need arises.

The required methods are:
\itemize{
\item \code{compute_layout}: Based on layer data compute a mapping between
panels, axes, and potentially other parameters such as faceting variable
level etc. This method must return a data.frame containing at least the
columns \code{PANEL}, \code{SCALE_X}, and \code{SCALE_Y} each containing
integer keys mapping a PANEL to which axes it should use. In addition the
data.frame can contain whatever other information is necessary to assign
observations to the correct panel as well as determining the position of
the panel.
\item \code{map_data}: This method is supplied the data for each layer in
turn and is expected to supply a \code{PANEL} column mapping each row to a
panel defined in the layout. Additionally this method can also add or
subtract data points as needed e.g. in the case of adding margins to
\code{facet_grid}.
\item \code{draw_panels}: This is where the panels are assembled into a
\code{gtable} object. The method receives, among others, a list of grobs
defining the content of each panel as generated by the Geoms and Coord
objects. The responsibility of the method is to decorate the panels with
axes and strips as needed, as well as position them relative to each other
in a gtable. For some of the automatic functions to work correctly, each
panel, axis, and strip grob name must be prefixed with "panel", "axis", and
"strip" respectively.
}

In addition to the methods described above, it is also possible to override
the default behaviour of one or more of the following methods:
\itemize{
\item \code{setup_params}:
\item \code{init_scales}: Given a master scale for x and y, create panel
specific scales for each panel defined in the layout. The default is to
simply clone the master scale.
\item \code{train_scales}: Based on layer data train each set of panel
scales. The default is to train it on the data related to the panel.
\item \code{finish_data}: Make last-minute modifications to layer data
before it is rendered by the Geoms. The default is to not modify it.
\item \code{draw_back}: Add a grob in between the background defined by the
Coord object (usually the axis grid) and the layer stack. The default is to
return an empty grob for each panel.
\item \code{draw_front}: As above except the returned grob is placed
between the layer stack and the foreground defined by the Coord object
(usually empty). The default is, as above, to return an empty grob.
\item \code{draw_labels}: Given the gtable returned by \code{draw_panels},
add axis titles to the gtable. The default is to add one title at each side
depending on the position and existence of axes.
}

All extension methods receive the content of the params field as the params
argument, so the constructor function will generally put all relevant
information into this field. The only exception is the \code{shrink}
parameter which is used to determine if scales are retrained after Stat
transformations has been applied.
}

\section{Stats}{


All \code{stat_*} functions (like \code{stat_bin}) return a layer that
contains a \code{Stat*} object (like \code{StatBin}). The \code{Stat*}
object is responsible for rendering the data in the plot.

Each of the \code{Stat*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Stat}, and each implements various methods and
fields. To create a new type of Stat object, you typically will want to
override one or more of the following:
\itemize{
\item One of :
\code{compute_layer(self, data, scales, ...)},
\code{compute_panel(self, data, scales, ...)}, or
\code{compute_group(self, data, scales, ...)}.

\code{compute_layer()} is called once per layer, \code{compute_panel_()}
is called once per panel, and \code{compute_group()} is called once per
group. All must return a data frame.

It's usually best to start by overriding \code{compute_group}: if
you find substantial performance optimisations, override higher up.
You'll need to read the source code of the default methods to see
what else you should be doing.

\code{data} is a data frame containing the variables named according
to the aesthetics that they're mapped to. \code{scales} is a list
containing the \code{x} and \code{y} scales. There functions are called
before the facets are trained, so they are global scales, not local
to the individual panels.\code{...} contains the parameters returned by
\code{setup_params()}.
\item \code{finish_layer(data, params)}: called once for each layer. Used
to modify the data after scales has been applied, but before the data is
handed of to the geom for rendering. The default is to not modify the
data. Use this hook if the stat needs access to the actual aesthetic
values rather than the values that are mapped to the aesthetic.
\item \code{setup_params(data, params)}: called once for each layer.
Used to setup defaults that need to complete dataset, and to inform
the user of important choices. Should return list of parameters.
\item \code{setup_data(data, params)}: called once for each layer,
after \code{setup_params()}. Should return modified \code{data}.
Default methods removes all rows containing a missing value in
required aesthetics (with a warning if \code{!na.rm}).
\item \code{required_aes}: A character vector of aesthetics needed to
render the geom.
\item \code{default_aes}: A list (generated by \code{\link[=aes]{aes()}} of
default values for aesthetics.
}
}

\section{Positions}{


All \code{position_*} functions (like \code{position_dodge}) return a
\code{Position*} object (like \code{PositionDodge}). The \code{Position*}
object is responsible for adjusting the position of overlapping geoms.

The way that the \code{position_*} functions work is slightly different from
the \code{geom_*} and \code{stat_*} functions, because a \code{position_*}
function actually "instantiates" the \code{Position*} object by creating a
descendant, and returns that.

Each of the \code{Position*} objects is a \code{\link[=ggproto]{ggproto()}} object,
descended from the top-level \code{Position}, and each implements the
following methods:
\itemize{
\item \code{compute_layer(self, data, params, panel)} is called once
per layer. \code{panel} is currently an internal data structure, so
this method should not be overridden.
\item \code{compute_panel(self, data, params, panel)} is called once per
panel and should return a modified data frame.

\code{data} is a data frame containing the variables named according
to the aesthetics that they're mapped to. \code{scales} is a list
containing the \code{x} and \code{y} scales. There functions are called
before the facets are trained, so they are global scales, not local
to the individual panels. \code{params} contains the parameters returned by
\code{setup_params()}.
\item \code{setup_params(data, params)}: called once for each layer.
Used to setup defaults that need to complete dataset, and to inform
the user of important choices. Should return list of parameters.
\item \code{setup_data(data, params)}: called once for each layer,
after \code{setup_params()}. Should return modified \code{data}.
Default checks that required aesthetics are present.
}

And the following fields
\itemize{
\item \code{required_aes}: a character vector giving the aesthetics
that must be present for this position adjustment to work.
}
}

\section{Scales}{


All \code{scale_*} functions (like \code{scale_x_continuous}) return a
\code{Scale*} object (like \code{ScaleContinuous}). The \code{Scale*}
object represents a single scale.

Each of the \code{Scale*} objects is a \code{\link[=ggproto]{ggproto()}} object,
descended from the top-level \code{Scale}.
}

\seealso{
ggproto
}
\keyword{datasets}
\keyword{internal}
