% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-brewer.r, R/zxx.r
\name{scale_colour_brewer}
\alias{scale_colour_brewer}
\alias{scale_fill_brewer}
\alias{scale_colour_distiller}
\alias{scale_fill_distiller}
\alias{scale_color_brewer}
\alias{scale_color_distiller}
\title{Sequential, diverging and qualitative colour scales from colorbrewer.org}
\usage{
scale_colour_brewer(..., type = "seq", palette = 1, direction = 1,
  aesthetics = "colour")

scale_fill_brewer(..., type = "seq", palette = 1, direction = 1,
  aesthetics = "fill")

scale_colour_distiller(..., type = "seq", palette = 1, direction = -1,
  values = NULL, space = "Lab", na.value = "grey50",
  guide = "colourbar", aesthetics = "colour")

scale_fill_distiller(..., type = "seq", palette = 1, direction = -1,
  values = NULL, space = "Lab", na.value = "grey50",
  guide = "colourbar", aesthetics = "fill")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[=discrete_scale]{discrete_scale()}} or, for
\code{distiller} scales, \code{\link[=continuous_scale]{continuous_scale()}} to control name,
limits, breaks, labels and so forth.}

\item{type}{One of seq (sequential), div (diverging) or qual (qualitative)}

\item{palette}{If a string, will use that named palette.  If a number, will
index into the list of palettes of appropriate \code{type}}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are as output by \code{\link[RColorBrewer:brewer.pal]{RColorBrewer::brewer.pal()}}. If -1, the
order of colors is reversed.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link[=rescale]{rescale()}} for a convience function
to map an arbitrary range to between 0 and 1.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{Colour to use for missing values}

\item{guide}{Type of legend. Use \code{"colourbar"} for continuous
colour bar, or \code{"legend"} for discrete colour legend.}
}
\description{
The \code{brewer} scales provides sequential, diverging and qualitative
colour schemes from ColorBrewer. These are particularly well suited to
display discrete values on a map. See \url{http://colorbrewer2.org} for
more information.
}
\details{
The \code{brewer} scales were carefully designed and tested on discrete data.
They were not designed to be extended to continuous data, but results often
look good. Your mileage may vary.
}
\note{
The \code{distiller} scales extends brewer to continuous scales by smoothly
interpolate 6 colours from any palette to a continuous scale.
}
\section{Palettes}{

The following palettes are available for use with these scales:
\describe{
\item{Diverging}{BrBG, PiYG, PRGn, PuOr, RdBu, RdGy, RdYlBu, RdYlGn, Spectral}
\item{Qualitative}{Accent, Dark2, Paired, Pastel1, Pastel2, Set1, Set2, Set3}
\item{Sequential}{Blues, BuGn, BuPu, GnBu, Greens, Greys, Oranges,
OrRd, PuBu, PuBuGn, PuRd, Purples, RdPu, Reds, YlGn, YlGnBu, YlOrBr, YlOrRd}
}
}

\examples{
dsamp <- diamonds[sample(nrow(diamonds), 1000), ]
(d <- ggplot(dsamp, aes(carat, price)) +
  geom_point(aes(colour = clarity)))
d + scale_colour_brewer()

# Change scale label
d + scale_colour_brewer("Diamond\\nclarity")

# Select brewer palette to use, see ?scales::brewer_pal for more details
d + scale_colour_brewer(palette = "Greens")
d + scale_colour_brewer(palette = "Set1")

\donttest{
# scale_fill_brewer works just the same as
# scale_colour_brewer but for fill colours
p <- ggplot(diamonds, aes(x = price, fill = cut)) +
  geom_histogram(position = "dodge", binwidth = 1000)
p + scale_fill_brewer()
# the order of colour can be reversed
p + scale_fill_brewer(direction = -1)
# the brewer scales look better on a darker background
p + scale_fill_brewer(direction = -1) + theme_dark()
}

# Use distiller variant with continous data
v <- ggplot(faithfuld) +
  geom_tile(aes(waiting, eruptions, fill = density))
v
v + scale_fill_distiller()
v + scale_fill_distiller(palette = "Spectral")
}
\seealso{
Other colour scales: \code{\link{scale_alpha}},
  \code{\link{scale_colour_gradient}},
  \code{\link{scale_colour_grey}},
  \code{\link{scale_colour_hue}},
  \code{\link{scale_colour_viridis_d}}
}
\concept{colour scales}
