\name{geom_point}
\alias{geom_point}
\alias{GeomPoint}
\title{geom\_point}
\description{Points, as for a scatterplot}
\details{
The point geom is used to create scatterplots.

This page describes geom\_point, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_point.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_point(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{y}: y position (\strong{required}) 
  \item \code{shape}: shape of point 
  \item \code{colour}: border colour 
  \item \code{size}: size 
  \item \code{fill}: internal colour 
}
}
\section{Advice}{
The scatterplot is useful for displaying the relationship between two continuous variables, although it can also be used with one continuous and one categorical variable, or two categorical variables.  See geom\_jitter for possibilities.

The \emph{bubblechart} is a scatterplot with a third variable mapped to the size of points.  There are no special names for scatterplots where another variable is mapped to point shape or colour, however.

The biggest potential problem with a scatterplot is overplotting: whenever you have more than a few points, points may be plotted on top of one another.  This can severely distort the visual appearance of the plot.  There is no one solution to this problem, but there are some techniques that can help.  You can add additional information with stat\_smooth, stat\_quantile or stat\_density2d.  If you have few unique x values, geom\_boxplot may also be useful.  Alternatively, you can summarise the number of points at each location and display that in some way, using stat\_sum.  Another technique is to use transparent points, \code{geom\_point(colour=alpha('black', 0.05))}

}
\usage{geom_point(mapping=NULL, data=NULL, stat="identity", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \code{\link{scale_size}}: To see how to scale area of points, instead of radius
  \item \code{\link{geom_jitter}}: Jittered points for categorical data
  \item \url{http://had.co.nz/ggplot2/geom_point.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
p <- ggplot(mtcars, aes(wt, mpg))
p + geom_point()

# Add aesthetic mappings
p + geom_point(aes(colour = qsec))
p + geom_point(aes(colour = cyl))
p + geom_point(aes(colour = factor(cyl)))
p + geom_point(aes(shape = factor(cyl)))
p + geom_point(aes(size = qsec))

# Change scales
p + geom_point(aes(colour = cyl)) + scale_colour_gradient(low = "red")
p + geom_point(aes(size = qsec)) + scale_area()
p + geom_point(aes(shape = factor(cyl))) + scale_shape(solid = FALSE)

# Set aesthetics to fixed value
p + geom_point(colour = "red", size = 3)
qplot(wt, mpg, data = mtcars, colour = I("red"), size = I(3))
    
# Transparent points:
qplot(mpg, wt, data = mtcars, size = I(5), 
  colour=I(alpha("black", 0.2)))

# Use qplot instead
qplot(wt, mpg, data = mtcars)
qplot(wt, mpg, data = mtcars, colour = factor(cyl))
qplot(wt, mpg, data = mtcars, colour = I("red"))
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
