\name{geom_abline}
\alias{geom_abline}
\alias{GeomAbline}
\title{geom\_abline}
\description{Line, specified by slope and intercept}
\details{
The abline geom adds a line with specified slope and intercept to the plot.

With its siblings geom\_hline and geom\_vline, it's useful for annotating plots.  You can supply the parameters for geom\_abline, intercept and slope, in two ways: either explicitly as fixed values, or stored in the data set.  If you specify the fixed values (\code{geom\_abline(intercept=0, slope=1)}) then the line will be the same in all panels, but if the intercept and slope are stored in the data, then can vary from panel to panel.  See the examples for more ideas.

This page describes geom\_abline, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_abline.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_abline(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{colour}: border colour 
  \item \code{size}: size 
  \item \code{linetype}: line type 
  \item \code{alpha}: transparency 
}
}
\usage{geom_abline(mapping=NULL, data=NULL, stat="abline", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \code{\link{stat_smooth}}: To add lines derived from the data
  \item \code{\link{geom_hline}}: for horizontal lines
  \item \code{\link{geom_vline}}: for vertical lines
  \item \code{\link{geom_segment}}: for a more general approach
  \item \url{http://had.co.nz/ggplot2/geom_abline.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
p <- qplot(wt, mpg, data = mtcars)

# Fixed slopes and intercepts
p + geom_abline() # Can't see it - outside the range of the data
p + geom_abline(intercept = 20)

# Calculate slope and intercept of line of best fit
coef(lm(mpg ~ wt, data = mtcars))
p + geom_abline(intercept = 37, slope = -5)
p + geom_abline(intercept = 10, colour = "red", size = 2)

# See ?stat_smooth for fitting smooth models to data
p + stat_smooth(method="lm", se=FALSE)

# Slopes and intercepts as data
p <- ggplot(mtcars, aes(x = wt, y=mpg), . ~ cyl) + geom_point()
df <- data.frame(a=rnorm(10, 25), b=rnorm(10, 0))
p + geom_abline(aes(intercept=a, slope=b), data=df)

# Slopes and intercepts from linear model
coefs <- ddply(mtcars, .(cyl), function(df) { 
  m <- lm(mpg ~ wt, data=df)
  data.frame(a = coef(m)[1], b = coef(m)[2]) 
})
str(coefs)
p + geom_abline(data=coefs, aes(intercept=a, slope=b))

# It's actually a bit easier to do this with stat_smooth
p + geom_smooth(aes(group=cyl), method="lm")
p + geom_smooth(aes(group=cyl), method="lm", fullrange=TRUE)

}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
