% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-mosaic.R
\name{theme_mosaic}
\alias{theme_mosaic}
\title{Theme for mosaic plots}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Themes set the general aspect of the plot such as the colour of the
background, gridlines, the size and colour of fonts.
\code{theme_mosaic} provides access to the regular ggplot2 theme, but removes any
background, most of the gridlines, and ensures an aspect ratio of 1 for better
viewing of the mosaics.
}
\examples{
library(ggmosaic)
data(happy)
ggplot(data = happy) +
  geom_mosaic(aes(weight=wtssall, x=product(health), fill=happy), na.rm=TRUE) +
  theme_mosaic()

}
