% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_funxy.R
\name{stat_funxy}
\alias{stat_funxy}
\alias{stat_centroid}
\alias{stat_midpoint}
\title{Apply function to position coordinates}
\usage{
stat_funxy(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  funx = force,
  funy = force,
  argx = list(),
  argy = list(),
  crop_other = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_centroid(
  ...,
  funx = mean,
  funy = mean,
  argx = list(na.rm = TRUE),
  argy = list(na.rm = TRUE)
)

stat_midpoint(..., argx = list(na.rm = TRUE), argy = list(na.rm = TRUE))
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{funx, funy}{A \code{function} to call on the layer's \code{x} and
\code{y} positions respectively.}

\item{argx, argy}{A named \code{list} containing arguments to the \code{funx},
and \code{funy} function calls.}

\item{crop_other}{A \code{logical} of length one; whether the other data
should be fitted to the length of \code{x} and \code{y} (default:
\code{TRUE}). Useful to set to \code{FALSE} when \code{funx} or \code{funy}
calculate summaries of length one that need to be recycled.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \code{StatFunxy} ggproto object, that can be added to a plot.
}
\description{
The function xy stat applies a function to the x- and y-coordinates of a
layers positions by group. The \code{stat_centroid()} and
\code{stat_midpoint()} functions are convenience wrappers for calculating
centroids and midpoints. \code{stat_funxy()} by default leaves the data
as-is, but can be supplied functions and arguments.
}
\details{
This statistic only makes a minimal attempt at ensuring that the
  results from calling both functions are of equal length. Results of length
  1 are recycled to match the longest length result.
}
\examples{
p <- ggplot(iris, aes(Sepal.Width, Sepal.Length, colour = Species))

# Labelling group midpoints
p + geom_point() +
  stat_midpoint(aes(label = Species, group = Species),
                geom = "text", colour = "black")

# Drawing segments to centroids
p + geom_point() +
  stat_centroid(aes(xend = Sepal.Width, yend = Sepal.Length),
                geom = "segment", crop_other = FALSE)

# Drawing intervals
ggplot(iris, aes(Sepal.Width, Sepal.Length, colour = Species)) +
  geom_point() +
  stat_funxy(geom = "path",
             funx = median, funy = quantile,
             argy = list(probs = c(0.1, 0.9)))
}
