% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_stringlegend.R
\name{guide_stringlegend}
\alias{guide_stringlegend}
\title{String legend}
\usage{
guide_stringlegend(
  title = waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  label.theme = NULL,
  label.hjust = NULL,
  label.vjust = NULL,
  family = NULL,
  face = NULL,
  size = NULL,
  spacing.x = NULL,
  spacing.y = NULL,
  spacing = NULL,
  default.units = "pt",
  direction = NULL,
  nrow = NULL,
  ncol = NULL,
  byrow = FALSE,
  reverse = FALSE,
  order = 0,
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{title.position}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link[ggplot2:element]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{label.theme}{A theme object for rendering the label text. Usually the
object of \code{\link[ggplot2:element]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[ggplot2:theme]{theme()}}.}

\item{label.hjust}{A numeric specifying horizontal justification of the
label text.}

\item{label.vjust}{A numeric specifying vertical justification of the label
text.}

\item{family}{A \code{character(1)} setting a font family for labels.}

\item{face}{A \code{character(1)} setting a font face for labels. One of the
following: \code{"plain"}, \code{"italic"} or \code{"bold"},
\code{"bold.italic"}.}

\item{size}{A \code{numeric(1)} setting the label text size in pts.}

\item{spacing.x, spacing.y, spacing}{A \code{numeric(1)} or \code{unit} for the
spacing between label rows and columns. Internally defaults to half the
size of the title.}

\item{default.units}{A \code{character(1)} indicating the default units to
use if the \code{spacing.*} arguments are only given as numeric vectors.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{nrow}{The desired number of rows of legends.}

\item{ncol}{The desired number of column of legends.}

\item{byrow}{logical. If \code{FALSE} (the default) the legend-matrix is
filled by columns, otherwise the legend-matrix is filled by rows.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{...}{ignored.}
}
\value{
A \code{guide}, \code{stringlegend} S3 object.
}
\description{
This type of legend shows colour and fill mappings as coloured text. It does
not draw keys as \code{guide_legend()} does.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = manufacturer))

# String legend can be set in the `guides()` function
p + guides(colour = guide_stringlegend(ncol = 2))

# The string legend can also be set as argument to the scale
p + scale_colour_viridis_d(guide = "stringlegend")
}
