% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/force_panelsize.R
\name{force_panelsizes}
\alias{force_panelsizes}
\title{Force a facetted plot to have specified panel sizes}
\usage{
force_panelsizes(rows = NULL, cols = NULL, respect = NULL)
}
\arguments{
\item{rows}{a \code{numeric} or \code{unit} vector for setting panel heights.}

\item{cols}{a \code{numeric} or \code{unit} vector for setting panel widths.}

\item{respect}{a \code{logical} value. If \code{TRUE}, widths and heights
specified in \code{"null" unit}s are proportional. If \code{FALSE},
\code{"null" unit}s in x- and y-direction vary idependently.}
}
\value{
A \code{forcedsize} S3 object that can be added to a plot.
}
\description{
Takes a ggplot and modifies its facet drawing behaviour such that the widths
and heights of panels are set by the user.
}
\details{
Forcing the panel sizes should in theory work regardless of what
  facetting choice was made, as long as this function is called after the
  facet specification. Even when no facets are specified, ggplot2 defaults to
  the \code{\link[ggplot2]{facet_null}} specification; a single panel.
  \code{force_panelsizes} works by wrapping the original panel drawing
  function inside a function that modifies the widths and heights of panel
  grobs in the original function's output gtable.

  When \code{rows} or \code{cols} are \code{numeric} vectors, panel sizes are
  defined as ratios i.e. relative \code{"null" unit}s. \code{rows} and
  \code{cols} vectors are repeated or shortened to fit the number of panels
  in their direction. When \code{rows} or \code{cols} are \code{NULL}, no
  changes are made in that direction.

  When \code{respect = NULL}, default behaviour specified elsewhere is
  inherited.

  No attempt is made to guarantee that the plot fits the output device. The
  \code{space} argument in \code{\link[ggplot2]{facet_grid}} will be
  overruled. When individual panels span multiple rows or columns, this
  function may not work as intended.
}
\examples{
ggplot(mtcars, aes(disp, mpg)) +
  geom_point() +
  facet_grid(vs ~ am) +
  force_panelsizes(rows = c(2, 1),
                   cols = c(2, 1))
}
\seealso{
\code{\link[ggplot2]{facet_grid}} \code{\link[ggplot2]{facet_wrap}}
  \code{\link[ggplot2]{facet_null}} \code{\link[grid]{unit}}
}
