% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dendrogram.R
\name{prepare_dendrogram}
\alias{prepare_dendrogram}
\title{Prepare dendrogram by transforming dendrogram segments.}
\usage{
prepare_dendrogram(
  dendro_in,
  context = c("rows", "cols"),
  dend_side,
  dend_defaults,
  dend_params,
  full_plt,
  layout,
  x_long,
  annot_df,
  annot_side,
  annot_pos,
  annot_size
)
}
\arguments{
\item{dendro_in}{Dendrogram object generated by
\code{some_matrix |> dist() |> hclust() |> as.dendrogram() |> dendextend::as.ggdend()}.}

\item{context}{Dimension the dendrogram will be plotted against (rows or columns).}

\item{dend_side}{String for dendrogram side.}

\item{dend_defaults}{List with dendrogram default parameters.}

\item{dend_params}{List with dendrogram parameters to overwrite defaults.}

\item{full_plt}{Logical indicating if the whole heatmap is plotted or not.}

\item{layout}{The heatmap layout (for reordering rows).}

\item{x_long}{Data frame containing the values that will be plotted in the heatmap.}

\item{annot_df}{Data frame containing annotations.}

\item{annot_side}{Logical specifying which side the annotation will be drawn, analogous to 'dend_down' or 'dend_left'
(use the one in the same dimension as the dendrogram).}

\item{annot_pos}{Vector of the annotation positions along the opposite dimension.}

\item{annot_size}{Size of annotation cells, specified in heatmap cells (1 being the size of one cell).}
}
\value{
Data frame with dendrogram segment and node parameters.
}
\description{
Prepare dendrogram by transforming dendrogram segments.
}
\keyword{internal}
