% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_prep_helpers.R
\name{pops_to_DB}
\alias{pops_to_DB}
\title{Pre-compute the scores for a given reference database}
\usage{
pops_to_DB(db, ...)
}
\arguments{
\item{db}{A dataframe with columns similar to those of \code{simulate_pops()}.
If \code{db} contains information (recommended!) about "meta" (meta population)
and "lat"/"lon" (location) these are carried over into the calculations}

\item{...}{Additional arguments passed to \code{score_add_df}}
}
\value{
A tibble with population and locus specific score information
}
\description{
Convert the counts from each population over a range of AIMs SNPs q
to observed likelihood ratio test, its mean and variance.
Based on these pre-computed the evaluation of a specific profile is done
using \code{genogeo} with the resulting dataframe as \code{df}.
}
\examples{
df_ <- simulate_pops(pop_n = 4, aims_n = 50)
df_db <- pops_to_DB(df_)
}
