% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genogeo.R
\name{genogeo}
\alias{genogeo}
\title{Likelihood ratio tests for AIMs}
\usage{
genogeo(profile, df, CI = 0.95, min_n = 75, grouping = "pop",
  tilt = FALSE, ...)
}
\arguments{
\item{profile}{The AIMs profile encoded as returned by the \code{profile_AA_x0} function.}

\item{df}{The database of reference populations as returned by the \code{pops_to_DB} function.}

\item{CI}{The confidence level used to reject or accept the various hypotheses (between 0 and 1).}

\item{min_n}{Minimum number of individuals in each database sample}

\item{grouping}{should \code{"pop"} (the default) or \code{"meta"} be used for aggregating the results.
Can also be \code{"cluster"} if this variable is defined in the input database.}

\item{tilt}{Should exponential titling be used to obtain more accurate $p$-values in the distribution's tail
(currently not implemented)}

\item{...}{Further arguments that are passed to other functions}
}
\value{
A tibble containing the $z$-scores, $p$-values etc for each population.
}
\description{
Computes the likelihood ratio test statistics for each population in a database of reference populations.
}
\examples{
df_ <- simulate_pops(pop_n = 20, aims_n = 50)
df_db <- pops_to_DB(df_)
profile <- random_AIMs_profile(df_db, keep_pop = TRUE)
profile$pop[1] # The true population
result <- genogeo(profile[,c("locus","x0")], df = df_db)
}
