% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_network.R
\name{plotHapNet}
\alias{plotHapNet}
\title{plotHapNet}
\usage{
plotHapNet(
  hapNet,
  size = "freq",
  scale = 1,
  cex = 0.8,
  cex.legend = 0.6,
  col.link = 1,
  link.width = 1,
  show.mutation = 2,
  backGround = backGround,
  hapGroup = hapGroup,
  legend = FALSE,
  show_size_legend = TRUE,
  show_color_legend = TRUE,
  pie.lim = c(0.5, 2),
  main = main,
  labels = TRUE,
  legend_version = 0,
  labels.cex = 0.8,
  labels.col = "blue",
  labels.adj = NULL,
  labels.font = 2,
  ...
)
}
\arguments{
\item{hapNet}{an object of class "haploNet"}

\item{size}{a numeric vector giving the diameter of the circles
representing the haplotypes: this is in the same unit than the
links and eventually recycled.}

\item{scale}{a numeric indicate the ratio of the scale of the links
representing the number of steps on the scale of the circles
representing the haplotypes or a character one of \code{c('log10', 'log2')}
indicate the scale method by \code{log10(size)} or \code{log2(size)}, respectively.
Default as 1}

\item{cex}{character expansion factor relative to current par("cex")}

\item{cex.legend}{same as \code{cex}, but for text in legend}

\item{col.link}{a character vector specifying the colours of the links;
eventually recycled.}

\item{link.width}{a numeric vector giving the width of the links;
eventually recycled.}

\item{show.mutation}{an integer value:

if 0, nothing is drawn on the links;

if 1, the mutations are shown with small segments on the links;

if 2, they are shown with small dots;

if 3, the number of mutations are printed on the links.}

\item{backGround}{a color vector with length equal to number of
Accession types}

\item{hapGroup}{a matrix used to draw pie charts for each haplotype;
its number of rows must be equal to the number of haplotypes}

\item{legend}{a logical specifying whether to draw the legend,
or a vector of length two giving the coordinates where to draw the legend;
\code{FALSE} by default.
If \code{TRUE}, the user is asked to click where to draw the legend.}

\item{show_size_legend, show_color_legend}{wether show size or color legend}

\item{pie.lim}{A numeric vector define the maximum and minmum pie size,
which will be avoid the pie to samll or too large}

\item{main}{The main title (on top) using font, size (character
    expansion) and color \code{par(c("font.main", "cex.main", "col.main"))}.}

\item{labels}{a logical specifying whether to identify the haplotypes
with their labels (default as TRUE)}

\item{legend_version}{the size legened style, default as 0}

\item{labels.cex}{the size of labels}

\item{labels.col}{the labels color}

\item{labels.adj}{a named list contains two length vectors defining the adjustment of labels.
The names should be exactly matched with the haplotype names.
default as NULL.}

\item{labels.font}{the font of labels, default as 2}

\item{...}{other parameters will pass to \code{plot} function}
}
\value{
No return value
}
\description{
plotHapNet
}
\details{
Additional parameters control the network features:
labels.cex = 1,
labels.font = 2,
link.color = "black",
link.type = 1,
link.type.alt = 2,
link.width = 1,
link.width.alt = 1,
altlinks = TRUE,
threshold = c(1,2),
haplotype.inner.color = "white",
haplotype.outer.color = "black",
mutations.cex = 1,
mutations.font = 1,
mutations.frame.background = "#0000FF4D",
mutations.frame.border = "black",
mutations.text.color = 1,
mutations.arrow.color = "black",
mutations.arrow.type = "triangle",
mutations.sequence.color = "#BFBFBF4D",
mutations.sequence.end = "round",
mutations.sequence.length = 0.3,
mutations.sequence.width = 5,
pie.inner.segments.color = "black",
pie.colors.function = rainbow,
scale.ratio = 1,
show.mutation = 2

The alter links could be eliminated by set the 'threshold' to 0 or set 'altlinks' as FALSE.
}
\examples{

\donttest{
data("geneHapR_test")
hapSummary <- hap_summary(hapResult)

# calculate haploNet
hapNet <- get_hapNet(hapSummary,
                     AccINFO = AccINFO, # accession types
                     groupName = colnames(AccINFO)[2])

# plot haploNet
plot(hapNet)

# plot haploNet
plotHapNet(hapNet,
           size = "freq",   # circle size
           scale = "log10", # scale circle with 'log10(size + 1)'
           cex = 1, # size of hap symbol
           col.link = 2, # link colors
           link.width = 2, # link widths
           show.mutation = 2, # mutation types one of c(0,1,2,3)
           legend = FALSE) # legend position
}
}
\seealso{
\code{\link[geneHapR:hap_summary]{hap_summary()}} and
\code{\link[geneHapR:get_hapNet]{get_hapNet()}}.
}
