# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'@title Fit Inverse Probability Weights Model
#'@description Fit inverse probability weights model.
#'@param m an integer vector of number of measurements for each subject.
#'@param Y a vector of responses for all subjects.
#'@param order the order for MAR remaining model.
#'@param trace whether or not the optimization iteration should be printed.
#'@export
ipw_estimation <- function(m, Y, order, trace = FALSE) {
    .Call('gee4_ipw_estimation', PACKAGE = 'gee4', m, Y, order, trace)
}

#'@title Fit (Weighted) Generalized Estimating Equations based on MCD
#'@description Fit (weighted) generalized estimating equations based on MCD.
#'@param m an integer vector of number of measurements for each subject.
#'@param Y a vector of responses for all subjects.
#'@param X model matrix for mean structure model.
#'@param Z model matrix for the diagonal matrix.
#'@param W model matrix for the lower triangular matrix.
#'@param H a vector of weights used in WGEE-MCD.
#'@param method choose 'gee-mcd' (Ye and Pan, 2006) or 'wgee-mcd' (Pan et al. 2012).
#'@param corrStruct choose 'id' (independent), 'cs' (compound symmetry) or ar1' (AR(1)).
#'@param rho a parameter used in the 'working' covariance structure.
#'@param start starting values for the parameters in the model.
#'@param trace the values of the objective function and the parameters are
#'       printed for all the trace'th iterations.
#'@param profile whether parameters should be estimated sequentially using the
#'       idea of profile likelihood or not.
#'@param errorMsg whether or not the error message should be print.
#'@export
gees_estimation <- function(m, Y, X, Z, W, H, method, corrStruct, rho, start, trace = FALSE, profile = TRUE, errorMsg = FALSE) {
    .Call('gee4_gees_estimation', PACKAGE = 'gee4', m, Y, X, Z, W, H, method, corrStruct, rho, start, trace, profile, errorMsg)
}

geerfit_id <- function(m, Y, X, Z, W, rho, start, trace = FALSE, profile = TRUE, errorMsg = FALSE) {
    .Call('gee4_geerfit_id', PACKAGE = 'gee4', m, Y, X, Z, W, rho, start, trace, profile, errorMsg)
}

geerfit_cs <- function(m, Y, X, Z, W, rho, start, trace = FALSE, profile = TRUE, errorMsg = FALSE) {
    .Call('gee4_geerfit_cs', PACKAGE = 'gee4', m, Y, X, Z, W, rho, start, trace, profile, errorMsg)
}

geerfit_ar1 <- function(m, Y, X, Z, W, rho, start, trace = FALSE, profile = TRUE, errorMsg = FALSE) {
    .Call('gee4_geerfit_ar1', PACKAGE = 'gee4', m, Y, X, Z, W, rho, start, trace, profile, errorMsg)
}

