% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-garch_reg.R
\name{rugarch_fit_impl}
\alias{rugarch_fit_impl}
\title{FIT - GARCH -----}
\usage{
rugarch_fit_impl(
  formula,
  data,
  a = 1,
  g = 1,
  ar = 1,
  ma = 1,
  tune_by = NULL,
  period = "auto",
  ...
)
}
\arguments{
\item{formula}{A dataframe of xreg (exogenous regressors)}

\item{data}{A numeric vector of values to fit}

\item{a}{The order of ARCH part}

\item{g}{The order of GARCH part}

\item{ar}{The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.}

\item{ma}{The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.}

\item{tune_by}{Parameter for tuning.}

\item{period}{Period}

\item{...}{Additional arguments passed to \code{forecast::Arima}}
}
\value{
A fitted model
}
\description{
#' Low-Level GARCH function for translating modeltime to forecast
#'
#' @param formula A dataframe of xreg (exogenous regressors)
#' @param data A numeric vector of values to fit
#' @param a The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.
#' @param g The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.
#' @param ... Additional arguments passed to \code{forecast::Arima}
#'
#' @export
garch_fit_impl <- function(formula, data, a = 1, g = 1, ar_no_apply = NULL, ma_no_apply = NULL, period = "auto", ...) {\preformatted{# X & Y
others <- list(...)

 y <- all.vars(formula)[1]
 x <- attr(stats::terms(formula, data = data), "term.labels")

outcome <- data[[y]]
predictors <- data \%>\% dplyr::select(dplyr::all_of(x))

# INDEX & PERIOD
# Determine Period, Index Col, and Index
index_tbl <- modeltime::parse_index_from_data(predictors)
period    <- modeltime::parse_period_from_index(index_tbl, period)
idx_col   <- names(index_tbl)
idx       <- timetk::tk_index(index_tbl)

# XREGS
# Clean names, get xreg recipe, process predictors
# xreg_recipe <- create_xreg_recipe(predictor, prepare = TRUE)
# xreg_matrix <- juice_xreg_recipe(xreg_recipe, format = "matrix")

# FIT
outcome <- stats::ts(outcome, frequency = period)

fit_garch <- tseries::garch(outcome, order = c(a, g), ...)

# RETURN
modeltime::new_modeltime_bridge(
    class = "garch_fit_impl",
    
    # Models
    models = list(
        model_1 = fit_garch
    ),
    
    # Data - Date column (matches original), .actual, .fitted, and .residuals columns
    data = tibble::tibble(
        !! idx_col  := idx,
        .actual      =  as.numeric(outcome),
        .fitted      =  fit_garch$fitted.values[,1],
        .residuals   =  fit_garch$residuals
    ),
    
    extras = list(
        y_var    = y,
        period   = period,
        otros    = others
    ),
    
    # Description - Convert arima model parameters to short description
    desc = stringr::str_glue('GARCH (\{fit_garch$order[1]\}, \{fit_garch$order[2]\}) Model')
)
}

}
}
\details{
#' @export
print.garch_fit_impl <- function(x, ...) {
print(x$models$model_1)
invisible(x)
}
Low-Level GARCH function for translating modeltime to forecast
}
