% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_utilities.R
\name{edge_matrix}
\alias{edge_matrix}
\alias{dag2edge_matrix}
\alias{edge_matrix2dag}
\title{Coerce dag to edge matrix}
\usage{
dag2edge_matrix(object, out = 1)

edge_matrix2dag(edge_matrix)
}
\arguments{
\item{object}{A graph, either an igraph object or an adjacency matrix.}

\item{out}{Format of the output, can be 1, 2, 3 or 4.}

\item{edge_matrix}{Lower triangular matrix representing a dag}
}
\description{
A DAG can be represented as a triangular matrix of regression coefficients.
}
\examples{
g <- dag(~x2|x1 + x3|x1:x2 + x4|x3)
dag2edge_matrix(g, out=1)
dag2edge_matrix(g, out=2)
dag2edge_matrix(g, out=3)
dag2edge_matrix(g, out=4)
d2 <- dag(~c|a:b+d:c)
dag2edge_matrix(d2)

}
