% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array_core_operations_cpp.R
\name{array-operations}
\alias{array-operations}
\alias{ar_expand}
\alias{\%a^\%}
\alias{ar_align}
\alias{\%aa\%}
\alias{ar_perm}
\alias{\%ap\%}
\alias{ar_marg}
\alias{\%a_\%}
\alias{ar_equal}
\alias{\%a==\%}
\title{Operations on multidimensional arrays.}
\usage{
ar_expand(tab, aux)

tab1 \%a^\% extra

ar_align(tab1, tab2)

tab1 \%aa\% tab2

ar_perm(tab, perm)

tab1 \%ap\% perm

ar_marg(tab, marg = NULL)

tab1 \%a_\% marg

ar_equal(tab1, tab2, eps = 1e-12)

tab1 \%a==\% tab2
}
\arguments{
\item{tab, tab1, tab2}{Multidimensional arrays.}

\item{aux}{Either a list with names and dimnames or a named array
from which such a list can be extracted.}

\item{extra}{List defining the extra dimensions.}

\item{perm}{A vector of indices or dimnames or a right hand sided
formula giving the desired permutiation.}

\item{marg}{A vector of indices or dimnames or a right hand sided
formula giving the desired marginal.}

\item{eps}{Criterion for checking equality of two arrays.}
}
\value{
Most functions return a multidimensional array.
}
\description{
Operations like marginalize, permute, slicing etc on
    arrays A multidimensional table (an array) is here a vector
    with a dim and a dimnames attribute.
}
\examples{

ar1 <- array(1:8, dim=c(2,2,2), dimnames=list("a"=1:2,"b"=1:2,"c"=1:2))
ar2 <- array(1:8, dim=c(2,2,2), dimnames=list("b"=1:2,"c"=1:2,"d"=1:2))

## ## armarg ##
## Marginalize down to the bc-array
ar_marg(ar1, 2:3)
ar_marg(ar1, c("b","c"))
ar_marg(ar1, ~b + c)

## Marginalize over 'everything'
ar_marg(ar1, NULL)
ar_marg(ar1, ~1)
ar_marg(ar1, character(0))
ar_marg(ar1, integer(0))

## This gives an error (as expected)
## ar_marg(ar1, c(2, 5))
## ar_marg(ar1, c("b","w"))
## ar_marg(ar1, ~b + w)
 
## ## ar_perm ##
ar_perm(ar1, 1:3)      ## No change - an abc-table
ar_perm(ar1, c(2,3,1)) ## A bca-table
ar_perm(ar1, ~b + c + a)

## This gives error
## ar_perm(ar1, c(2,1))
## ar_perm(ar1, c(2,1,5))
## ar_perm(ar1, c(2,1,NA))

## ## ar_mult etc ##
## Multiply two arrays
out <- ar_mult(ar1, ar2)
out <- ar_perm(out, ~a + b + c + d) ## Just for comparison below
ftable(out)

## Alternative approch
df1 <- as.data.frame.table(ar1)
df2 <- as.data.frame.table(ar2)
df3 <- merge(df1, df2, by=c("b","c"))
df3 <- transform(df3, Freq=Freq.x*Freq.y)
ar3 <- xtabs(Freq ~ a + b + c + d, data=df3)
ftable(ar3)

## ## ar_expand ##
ar1.e <- ar_expand(ar1, ar2)
## ar1.e has dimnames b,c,d,a; values are simply replicated for each
## level of d.
dimnames(ar1.e)
ftable(ar1.e, row.vars="d")
## ar_expand:
ar_expand(ar1, list(u=1:2))
ar1 \%a^\% list(u=1:2)

## ## aralign ##
ar2.e <- ar_expand(ar2, ar1)
names(dimnames(ar2.e))
names(dimnames(ar1.e))
out <- ar_align(ar1.e, ar2.e)
names(dimnames(out)) ## Same as ar2.e


}
\seealso{
\code{\link{aperm}}, \code{\link{ar_perm}},
    \code{\link{ar_slice}}, \code{\link{ar_slice_entries}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
