% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-slice.R
\name{array-slice}
\alias{ar_slice}
\alias{ar_slice_entries}
\alias{ar_slice_mult}
\alias{ar_slice_prim}
\alias{array-slice}
\title{Array slices}
\usage{
ar_slice(tab, slice = NULL, margin = names(slice), drop = TRUE,
  as.array = FALSE)

ar_slice_prim(tab, slice, drop = TRUE)

ar_slice_mult(tab, slice, val = 1, comp = 0)

ar_slice_entries(tab, slice, complement = FALSE)
}
\arguments{
\item{tab}{An array with named dimnames.}

\item{slice}{A list defining the slice.}

\item{margin}{Names of variables in slice.}

\item{drop}{If TRUE then dimensions with only one level will be dropped
from the output.}

\item{as.array}{If the resulting array is one-dimensional the
result will by default be a vector with no dim attribute unless
as.array is TRUE.}

\item{val}{The values that entries in the slice will be multiplied
with.}

\item{comp}{The values that entries NOT in the slice will be
multiplied with.}

\item{complement}{If TRUE the complement of the entries are returned.}
}
\description{
Functions for extracting slices of arrays
}
\examples{

x = HairEyeColor
s = list(Hair=c("Black","Brown"), Eye=c("Brown", "Blue"))

## arslice
s1 = ar_slice(x, slice=s)
s1

## ar_slice_entries
ar_slice_entries(x, slice=s)
ar_slice_entries(x, slice=s, complement=TRUE)

## ar_slice_mult
s2 = ar_slice_mult(x, slice=s)
s2

## arslice_prim does the same as arslice - faster, but the function is less
# flexible
sp = list(c(1,2), c(1,2), TRUE)
ar_slice_prim(x, slice=sp)
ar_slice(x, slice=s)
if ( require(microbenchmark) ){
  microbenchmark(ar_slice_prim(x, slice=sp), ar_slice(x, slice=s))
}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{ar_perm}}, \code{\link{ar_marg}}, \code{\link{ar_mult}},
\code{\link{ar_div}}, \code{\link{ar_add}}, \code{\link{ar_subt}}, \code{\link{ar_sum}},
\code{\link{ar_prod}}
}

