% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graph-cliques}
\alias{getCliques}
\alias{getCliques.default}
\alias{getCliques.graphNEL}
\alias{graph-cliques}
\alias{maxCliqueMAT}
\title{Get cliques of an undirected graph}
\usage{
getCliques(object)

\method{getCliques}{graphNEL}(object)

\method{getCliques}{default}(object)

maxCliqueMAT(amat)
}
\arguments{
\item{object}{An undirected graph represented either as a \code{graphNEL}
object, a (dense) \code{matrix}, a (sparse) \code{dgCMatrix}}

\item{amat}{An adjacency matrix.}
}
\value{
A list.
}
\description{
Return a list of (maximal) cliques of an undirected graph.
}
\details{
In graph theory, a clique is often a complete subset of a graph. A maximal
clique is a clique which can not be enlarged. In statistics (and that is the
convention we follow here) a clique is usually understood to be a maximal
clique.

Finding the cliques of a general graph is an NP complete problem. Finding
the cliques of triangualted graph is linear in the number of cliques.

The workhorse is the \code{maxCliqueMAT} function which calls the
\code{maxClique} function in the \code{RBGL} package.
}
\examples{

## graphNEL
uG1 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a)
getCliques(uG1)

## adjacency matrix
uG2 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a, result="matrix")
getCliques(uG2)

## adjacency matrix (sparse)
uG3 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a, result="Matrix")
getCliques(uG3)


}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{ug}}, \code{\link{dag}}, \code{\link{mcs}},
    \code{\link{mcsMAT}}, \code{\link{rip}}, \code{\link{ripMAT}},
    \code{\link{moralize}}, \code{\link{moralizeMAT}}
}
\keyword{utilities}

