% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-algebra.R
\name{array-algebra}
\alias{\%a*\%}
\alias{\%a+\%}
\alias{\%a-\%}
\alias{\%a/\%}
\alias{aradd}
\alias{ardiv}
\alias{ardiv0}
\alias{armult}
\alias{arprod}
\alias{array-algebra}
\alias{arsubt}
\alias{arsum}
\alias{tabAdd}
\alias{tabDiv}
\alias{tabDiv0}
\alias{tabMult}
\alias{tabSubt}
\title{Array algebra}
\usage{
a1 \%a+\% a2

a1 \%a-\% a2

a1 \%a*\% a2

a1 \%a/\% a2

aradd(a1, a2)

arsubt(a1, a2)

armult(a1, a2)

ardiv(a1, a2)

ardiv0(a1, a2)

arsum(...)

arprod(...)
}
\arguments{
\item{a, a1, a2, ...}{Arrays (with named dimnames)}
}
\description{
Addition, subtraction etc. of arrays
}
\examples{
hec <- HairEyeColor
a1 <- armarg(hec, c("Hair", "Eye"))
a2 <- armarg(hec, c("Hair", "Sex"))
a3 <- armarg(hec, c("Eye", "Sex"))

## Binary operations
a1 \%a+\% a2
a1 \%a-\% a2
a1 \%a*\% a2
a1 \%a/\% a2

arsum(a1, a2, a3)
arprod(a1, a2, a3)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}

