% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amfewma.R
\name{AMFEWMA_PhaseII}
\alias{AMFEWMA_PhaseII}
\title{Adaptive Multivariate Functional EWMA control chart - Phase II}
\usage{
AMFEWMA_PhaseII(mfdobj_2, mod_1, n_seq_2 = 1, l_seq_2 = 2000)
}
\arguments{
\item{mfdobj_2}{An object of class \code{mfd} containing the Phase II multivariate
functional data set, to be monitored with the AMFEWMA control chart.}

\item{mod_1}{The output of the Phase I achieved through the
\code{\link{AMFEWMA_PhaseI}} function.}

\item{n_seq_2}{If it is 1, the Phase II monitoring statistic is calculated on
the data sequence.
If it is an integer number larger than 1, a number \code{n_seq_2} of
bootstrap sequences are sampled with replacement from \code{mfdobj_2}
to allow uncertainty quantification on the estimation of the run length.
Default value is 1.}

\item{l_seq_2}{If \code{n_seq_2} is larger than 1, this parameter sets the
length of each bootstrap sequence to be generated.
Default value is 2000 (which is ignored if the default value}
}
\value{
A list with the following elements.
\itemize{
\item \code{ARL_2}: the average run length estimated over the
bootstrap sequences. If \code{n_seq_2} is 1, it is simply the run length
observed over the Phase II sequence, i.e., the number of observations
up to the first alarm,
\item \code{RL}: the run length
observed over the Phase II sequence, i.e., the number of observations
up to the first alarm,
\item \code{V2}: a list with length \code{n_seq_2}, containing the
AMFEWMA monitoring statistic in Equation (8) of Capezza
et al. (2024), calculated in each bootstrap sequence, until the first alarm.
\item \code{cc}: a data frame with the information needed to plot the
AMFEWMA control chart in Phase II, with the following columns.
\code{id} contains the id of each multivariate functional observation,
\code{amfewma_monitoring_statistic} contains the AMFEWMA monitoring
statistic values calculated on the Phase II sequence,
\code{amfewma_monitoring_statistic_lim} is the upper control limit.
}
}
\description{
This function performs Phase II of the
Adaptive Multivariate Functional EWMA (AMFEWMA) control chart proposed
by Capezza et al. (2024)
}
\examples{
\donttest{
set.seed(0)
library(funcharts)
dat_I <- simulate_mfd(nobs = 200,
                      correlation_type_x = c("Bessel", "Bessel", "Bessel"),
                      sd_x = c(0.3, 0.3, 0.3))
dat_tun <- simulate_mfd(nobs = 200,
                        correlation_type_x = c("Bessel", "Bessel", "Bessel"),
                        sd_x = c(0.3, 0.3, 0.3))
dat_II <- simulate_mfd(nobs = 20,
                       correlation_type_x = c("Bessel", "Bessel", "Bessel"),
                       shift_type_x = c("C", "C", "C"),
                       d_x = c(2, 2, 2),
                       sd_x = c(0.3, 0.3, 0.3))
mfdobj_I <- get_mfd_list(dat_I$X_list, lambda = 1e-2)
mfdobj_tun <- get_mfd_list(dat_tun$X_list, lambda = 1e-2)
mfdobj_II <- get_mfd_list(dat_II$X_list, lambda = 1e-2)

# p <- plot_mfd(mfdobj_I[1:100])
# lines_mfd(p, mfdobj_II, col = "red")


mod <- AMFEWMA_PhaseI(mfdobj = mfdobj_I,
                      mfdobj_tuning = mfdobj_tun,
                      lambda = 0.1,
                      k = c(1, 2))

cc <- AMFEWMA_PhaseII(mfdobj_2 = rbind_mfd(mfdobj_I[1:100], mfdobj_II),
                      mod_1 = mod)
plot_control_charts(cc$cc, nobsI = 100)
}

}
\references{
Capezza, C., Capizzi, G., Centofanti, F., Lepore, A., Palumbo, B. (2025)
An Adaptive Multivariate Functional EWMA Control Chart.
\emph{Journal of Quality Technology},  57(1):1--15,
doi:https://doi.org/10.1080/00224065.2024.2383674.
}
