% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_accolites.R
\name{get_accolites}
\alias{get_accolites}
\title{Get Accolites for a Given Leaf Label}
\usage{
get_accolites(leaf_label, window_data, portion_len, multiple)
}
\arguments{
\item{leaf_label}{A character string representing the label of the leaf for which to find accolites.}

\item{window_data}{A data frame or matrix where the row names correspond to the labels of elements,
containing the data from which accolites will be extracted.}

\item{portion_len}{An integer specifying the total length of the portion used to define the accolites. 
The overlap is computed as half of this length.}

\item{multiple}{A logical indicating whether to check for multiple curves. If TRUE, the function 
filters out accolites that do not originate from the same curve as the specified leaf label.}
}
\value{
A character vector containing the labels of the identified accolites. 
        If no accolites are found, the function returns an empty vector.
}
\description{
This function retrieves the accolites (adjacent elements) of a specified leaf label from a dataset. 
Accolites are defined as the elements that overlap with the specified portion length around the leaf.
The function can filter accolites based on their origin curve in cases where multiple curves are present.
}
\details{
The function works as follows:
1. It calculates the index of the specified leaf label within the provided `window_data`.
2. Determines the range of indices representing the accolites by calculating the overlap based on `portion_len`.
3. Retrieves the corresponding leaf labels from the `window_data`.
4. If the `multiple` argument is TRUE, it checks if the accolites come from the same curve as the leaf label, 
   removing those that do not.
}
