% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fmx.R
\name{as.fmx.Skew.t}
\alias{as.fmx.Skew.t}
\title{Convert \code{Skew.t} fit from \CRANpkg{mixsmsn} to \linkS4class{fmx}}
\usage{
\method{as.fmx}{Skew.t}(x, data, ...)
}
\arguments{
\item{x}{\code{'Skew.t'} object,
returned from \link[mixsmsn]{smsn.mix} with parameter
\code{family = 'Skew.t'}}

\item{data}{\link[base]{numeric} \link[base]{vector}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{as.fmx.Skew.t} returns an \linkS4class{fmx} object.
}
\description{
To convert \code{Skew.t} object (from package \CRANpkg{mixsmsn})
to \linkS4class{fmx} class.
}
\note{
\link[mixsmsn]{smsn.mix} does not offer a parameter to keep the input data, as of 2021-10-06.
}
\examples{
\donttest{
# mixsmsn::smsn.mix with option `family = 'Skew.t'` is slow

library(mixsmsn)
# ?smsn.mix
arg1 = c(mu = 5, sigma2 = 9, lambda = 5, nu = 5)
arg2 = c(mu = 20, sigma2 = 16, lambda = -3, nu = 5)
arg3 = c(mu = 35, sigma2 = 9, lambda = -6, nu = 5)
set.seed(120); x = rmix(n = 1e3L, p=c(.5, .2, .3), family = 'Skew.t', 
  arg = list(unname(arg1), unname(arg2), unname(arg3)))

# Skew t
class(m3 <- smsn.mix(x, nu = 3, g = 3, family = 'Skew.t', calc.im = FALSE))
mix.hist(y = x, model = m3)
m3a = as.fmx(m3, data = x)
hist(x, freq = FALSE)
curve(dfmx(x, dist = m3a), xlim = range(x), add = TRUE)
(l3a = logLik(m3a))
stopifnot(all.equal.numeric(AIC(l3a), m3$aic), all.equal.numeric(BIC(l3a), m3$bic))
}

}
